---
title: "danog\\Decoder\\UniqueFileId: Represents decoded unique bot API file ID."
description: ""

---
# `danog\Decoder\UniqueFileId`
[Back to index](../../index.md)

> Author: Daniil Gentili <daniil@daniil.it>  
  

Represents decoded unique bot API file ID.  



## Properties
* `$type`: `\danog\Decoder\UniqueFileIdType` File type.
* `$id`: `?int` File ID.
* `$subType`: `?int` Photo subtype.
* `$volumeId`: `?int` Photo volume ID.
* `$localId`: `?int` Photo local ID.
* `$stickerSetId`: `?int` Sticker set ID.
* `$stickerSetVersion`: `?int` Sticker set version.
* `$url`: `?string` Weblocation URL.

## Method list:
* [`__construct(\danog\Decoder\UniqueFileIdType $type, ?int $id = NULL, ?int $subType = NULL, ?int $volumeId = NULL, ?int $localId = NULL, ?int $stickerSetId = NULL, ?int $stickerSetVersion = NULL, ?string $url = NULL)`](#__construct-danog-decoder-uniquefileidtype-type-int-id-null-int-subtype-null-int-volumeid-null-int-localid-null-int-stickersetid-null-int-stickersetversion-null-string-url-null)
* [`getUniqueBotAPI(): string`](#getuniquebotapi-string)
* [`fromUniqueBotAPI(string $fileId): self`](#fromuniquebotapi-string-fileid-self)
* [`fromBotAPI(string $fileId): self`](#frombotapi-string-fileid-self)
* [`fromFileId(\danog\Decoder\FileId $fileId): self`](#fromfileid-danog-decoder-fileid-fileid-self)

## Methods:
### `__construct(\danog\Decoder\UniqueFileIdType $type, ?int $id = NULL, ?int $subType = NULL, ?int $volumeId = NULL, ?int $localId = NULL, ?int $stickerSetId = NULL, ?int $stickerSetVersion = NULL, ?string $url = NULL)`

Basic constructor function.


Parameters:

* `$type`: `\danog\Decoder\UniqueFileIdType`   
* `$id`: `?int`   
* `$subType`: `?int`   
* `$volumeId`: `?int`   
* `$localId`: `?int`   
* `$stickerSetId`: `?int`   
* `$stickerSetVersion`: `?int`   
* `$url`: `?string`   


#### See also: 
* [`\danog\Decoder\UniqueFileIdType`: Represents decoded unique bot API file ID type.](../../danog/Decoder/UniqueFileIdType.md)




### `getUniqueBotAPI(): string`

Get unique bot API file ID.



### `fromUniqueBotAPI(string $fileId): self`

Decode unique bot API file ID.


Parameters:

* `$fileId`: `string` Bot API file ID  



### `fromBotAPI(string $fileId): self`

Convert full bot API file ID to unique file ID.


Parameters:

* `$fileId`: `string` Full bot API file ID  



### `fromFileId(\danog\Decoder\FileId $fileId): self`

Turn full file ID into unique file ID.


Parameters:

* `$fileId`: `\danog\Decoder\FileId` Full file ID  


#### See also: 
* [`\danog\Decoder\FileId`: Represents decoded bot API file ID.](../../danog/Decoder/FileId.md)




---
Generated by [danog/phpdoc](https://phpdoc.daniil.it)
