---
title: "danog\\Decoder\\FileId: Represents decoded bot API file ID."
description: ""

---
# `danog\Decoder\FileId`
[Back to index](../../index.md)

> Author: Daniil Gentili <daniil@daniil.it>  
  

Represents decoded bot API file ID.  



## Properties
* `$dcId`: `int` DC ID.
* `$type`: `\danog\Decoder\FileIdType` File type.
* `$id`: `?int` File id.
* `$accessHash`: `int` File access hash.
* `$photoSizeSource`: `?\danog\Decoder\PhotoSizeSource` Photo size source.
* `$volumeId`: `?int` Photo volume ID.
* `$localId`: `?int` Photo local ID.
* `$fileReference`: `?string` File reference.
* `$url`: `?string` File URL for weblocation.
* `$version`: `int` Bot API file ID version.
* `$subVersion`: `int` Bot API file ID subversion.

## Method list:
* [`__construct(int $dcId, \danog\Decoder\FileIdType $type, ?int $id, int $accessHash, ?\danog\Decoder\PhotoSizeSource $photoSizeSource = NULL, ?int $volumeId = NULL, ?int $localId = NULL, ?string $fileReference = NULL, ?string $url = NULL, int $version = 4, int $subVersion = 47)`](#__construct-int-dcid-danog-decoder-fileidtype-type-int-id-int-accesshash-danog-decoder-photosizesource-photosizesource-null-int-volumeid-null-int-localid-null-string-filereference-null-string-url-null-int-version-4-int-subversion-47)
* [`fromBotAPI(string $fileId): self`](#frombotapi-string-fileid-self)
* [`getBotAPI(): string`](#getbotapi-string)
* [`getUnique(): \danog\Decoder\UniqueFileId`](#getunique-danog-decoder-uniquefileid)
* [`getUniqueBotAPI(): string`](#getuniquebotapi-string)

## Methods:
### `__construct(int $dcId, \danog\Decoder\FileIdType $type, ?int $id, int $accessHash, ?\danog\Decoder\PhotoSizeSource $photoSizeSource = NULL, ?int $volumeId = NULL, ?int $localId = NULL, ?string $fileReference = NULL, ?string $url = NULL, int $version = 4, int $subVersion = 47)`

Basic constructor function.


Parameters:

* `$dcId`: `int`   
* `$type`: `\danog\Decoder\FileIdType`   
* `$id`: `?int`   
* `$accessHash`: `int`   
* `$photoSizeSource`: `?\danog\Decoder\PhotoSizeSource`   
* `$volumeId`: `?int`   
* `$localId`: `?int`   
* `$fileReference`: `?string`   
* `$url`: `?string`   
* `$version`: `int`   
* `$subVersion`: `int`   


#### See also: 
* [`\danog\Decoder\FileIdType`: Represents decoded bot API file ID type.](../../danog/Decoder/FileIdType.md)
* [`\danog\Decoder\PhotoSizeSource`: Represents source of photosize.](../../danog/Decoder/PhotoSizeSource.md)




### `fromBotAPI(string $fileId): self`

Decode file ID from bot API file ID.


Parameters:

* `$fileId`: `string` File ID  



### `getBotAPI(): string`

Get bot API file ID.



### `getUnique(): \danog\Decoder\UniqueFileId`

Get unique file ID from file ID.


#### See also: 
* [`\danog\Decoder\UniqueFileId`: Represents decoded unique bot API file ID.](../../danog/Decoder/UniqueFileId.md)




### `getUniqueBotAPI(): string`

Get unique bot API file ID from file ID.



---
Generated by [danog/phpdoc](https://phpdoc.daniil.it)
