---
title: "danog\\TelegramEntities\\Entities: Class that represents a message + set of Telegram entities."
description: ""

---
# `danog\TelegramEntities\Entities`
[Back to index](../../index.md)

> Author: Daniil Gentili <daniil@daniil.it>  
  

Class that represents a message + set of Telegram entities.  



## Properties
* `$message`: `string` Converted message
* `$entities`: `list<TEntity>` Converted entities.

## Method list:
* [`__construct(string $message, array $entities)`](#__construct)
* [`fromMarkdown(string $markdown): \danog\TelegramEntities\Entities`](#fromMarkdown)
* [`fromHtml(string $html): \danog\TelegramEntities\Entities`](#fromHtml)
* [`toHTML(bool $allowTelegramTags = false): string`](#toHTML)

## Methods:
### <a name="__construct"></a> `__construct(string $message, array $entities)`

Creates an Entities container using a message and a list of entities.


Parameters:

* `$message`: `string`   
* `$entities`: `array`   



### <a name="fromMarkdown"></a> `fromMarkdown(string $markdown): \danog\TelegramEntities\Entities`

Manually convert markdown to a message and a set of entities.


Parameters:

* `$markdown`: `string`   


Return value: Object containing message and entities


### <a name="fromHtml"></a> `fromHtml(string $html): \danog\TelegramEntities\Entities`

Manually convert HTML to a message and a set of entities.


Parameters:

* `$html`: `string`   


Return value: Object containing message and entities


### <a name="toHTML"></a> `toHTML(bool $allowTelegramTags = false): string`

Convert a message and a set of entities to HTML.


Parameters:

* `$allowTelegramTags`: `bool` Whether to allow telegram-specific tags like tg-spoiler, tg-emoji, mention links and so on...  



---
Generated by [danog/phpdoc](https://phpdoc.daniil.it)
