<?php declare(strict_types=1);
/**
 * This file is automatic generated by build_docs.php file
 * and is used only for autocomplete in multiple IDE
 * don't modify manually.
 */

namespace danog\MadelineProto\Namespace;

interface Messages
{
    /**
     * Returns the list of messages by their IDs.
     *
     * @param list<int|array>|array<never, never> $id Array of Message ID list @see https://docs.madelineproto.xyz/API_docs/types/InputMessage.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getMessages(array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Returns the current user dialog list.
     *
     * @param bool $exclude_pinned Exclude pinned dialogs
     * @param int $folder_id [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
     * @param int $offset_date [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets) (`top_message` ID used for pagination)
     * @param array|int|string $offset_peer [Offset peer for pagination](https://core.telegram.org/api/offsets) @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $limit Number of list elements to be returned
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @param ?int $takeoutId Optional takeout ID, generated using account.initTakeoutSession, see [the takeout docs](https://core.telegram.org/api/takeout) for more info.
     * @return array{_: 'messages.dialogs', dialogs: list<array>, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.dialogsSlice', count: array, dialogs: list<array>, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.dialogsNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Dialogs.html
     */
    public function getDialogs(bool|null $exclude_pinned = null, int|null $folder_id = null, int|null $offset_date = 0, int|null $offset_id = 0, array|int|string|null $offset_peer = null, int|null $limit = 0, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null, ?int $takeoutId = null): array;

    /**
     * Returns the conversation history with one interlocutor / within a chat.
     *
     * @param array|int|string $peer Target peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $offset_id Only return messages starting from the specified message ID
     * @param int $offset_date Only return messages sent before the specified date
     * @param int $add_offset Number of list elements to be skipped, negative values are also accepted.
     * @param int $limit Number of results to return
     * @param int $max_id If a positive value was transferred, the method will return only messages with IDs less than **max\_id**
     * @param int $min_id If a positive value was transferred, the method will return only messages with IDs more than **min\_id**
     * @param list<int>|array<never, never> $hash [Result hash](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @param ?int $takeoutId Optional takeout ID, generated using account.initTakeoutSession, see [the takeout docs](https://core.telegram.org/api/takeout) for more info.
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getHistory(array|int|string|null $peer = null, int|null $offset_id = 0, int|null $offset_date = 0, int|null $add_offset = 0, int|null $limit = 0, int|null $max_id = 0, int|null $min_id = 0, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null, ?int $takeoutId = null): array;

    /**
     * Search for messages.
     *
     * @param array{_: 'inputMessagesFilterEmpty'}|array{_: 'inputMessagesFilterPhotos'}|array{_: 'inputMessagesFilterVideo'}|array{_: 'inputMessagesFilterPhotoVideo'}|array{_: 'inputMessagesFilterDocument'}|array{_: 'inputMessagesFilterUrl'}|array{_: 'inputMessagesFilterGif'}|array{_: 'inputMessagesFilterVoice'}|array{_: 'inputMessagesFilterMusic'}|array{_: 'inputMessagesFilterChatPhotos'}|array{_: 'inputMessagesFilterPhoneCalls', missed?: bool}|array{_: 'inputMessagesFilterRoundVoice'}|array{_: 'inputMessagesFilterRoundVideo'}|array{_: 'inputMessagesFilterMyMentions'}|array{_: 'inputMessagesFilterGeo'}|array{_: 'inputMessagesFilterContacts'}|array{_: 'inputMessagesFilterPinned'} $filter Filter to return only specified message types @see https://docs.madelineproto.xyz/API_docs/types/MessagesFilter.html
     * @param array|int|string $peer User or chat, histories with which are searched, or [(inputPeerEmpty)](https://docs.madelineproto.xyz/API_docs/constructors/inputPeerEmpty.html) constructor to search in all private chats and [normal groups (not channels) »](https://core.telegram.org/api/channel). Use [messages.searchGlobal](https://docs.madelineproto.xyz/API_docs/methods/messages.searchGlobal.html) to search globally in all chats, groups, supergroups and channels. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $q Text search request
     * @param array|int|string $from_id Only return messages sent by the specified user ID @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $saved_peer_id Search within the [saved message dialog »](https://core.telegram.org/api/saved-messages) with this ID. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon?: string}|array{_: 'reactionCustomEmoji', document_id?: int}> $saved_reaction Array of  @see https://docs.madelineproto.xyz/API_docs/types/Reaction.html
     * @param int $top_msg_id [Thread ID](https://core.telegram.org/api/threads)
     * @param int $min_date If a positive value was transferred, only messages with a sending date bigger than the transferred one will be returned
     * @param int $max_date If a positive value was transferred, only messages with a sending date smaller than the transferred one will be returned
     * @param int $offset_id Only return messages starting from the specified message ID
     * @param int $add_offset [Additional offset](https://core.telegram.org/api/offsets)
     * @param int $limit [Number of results to return](https://core.telegram.org/api/offsets)
     * @param int $max_id [Maximum message ID to return](https://core.telegram.org/api/offsets)
     * @param int $min_id [Minimum message ID to return](https://core.telegram.org/api/offsets)
     * @param list<int>|array<never, never> $hash [Hash](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @param ?int $takeoutId Optional takeout ID, generated using account.initTakeoutSession, see [the takeout docs](https://core.telegram.org/api/takeout) for more info.
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function search(array $filter, array|int|string|null $peer = null, string|null $q = '', array|int|string|null $from_id = null, array|int|string|null $saved_peer_id = null, array|null $saved_reaction = null, int|null $top_msg_id = null, int|null $min_date = 0, int|null $max_date = 0, int|null $offset_id = 0, int|null $add_offset = 0, int|null $limit = 0, int|null $max_id = 0, int|null $min_id = 0, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null, ?int $takeoutId = null): array;

    /**
     * Marks message history as read.
     *
     * @param array|int|string $peer Target user or group @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $max_id If a positive value is passed, only messages with identifiers less or equal than the given one will be read
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedMessages', pts: int, pts_count: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedMessages.html
     */
    public function readHistory(array|int|string|null $peer = null, int|null $max_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Deletes communication history.
     *
     * @param bool $just_clear Just clear history for the current user, without actually removing messages for every chat user
     * @param bool $revoke Whether to delete the message history for all chat participants
     * @param array|int|string $peer User or chat, communication history of which will be deleted @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $max_id Maximum ID of message to delete
     * @param int $min_date Delete all messages newer than this UNIX timestamp
     * @param int $max_date Delete all messages older than this UNIX timestamp
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedHistory', pts: int, pts_count: int, offset: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedHistory.html
     */
    public function deleteHistory(bool|null $just_clear = null, bool|null $revoke = null, array|int|string|null $peer = null, int|null $max_id = 0, int|null $min_date = null, int|null $max_date = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Deletes messages by their identifiers.
     *
     * @param bool $revoke Whether to delete messages for all participants of the chat
     * @param list<int>|array<never, never> $id Message ID list
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedMessages', pts: int, pts_count: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedMessages.html
     */
    public function deleteMessages(bool|null $revoke = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Confirms receipt of messages by a client, cancels PUSH-notification sending.
     *
     * @param int $max_id Maximum message ID available in a client.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<array{_: 'receivedNotifyMessage', id: int}> Array of  @see https://docs.madelineproto.xyz/API_docs/types/ReceivedNotifyMessage.html
     */
    public function receivedMessages(int|null $max_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Sends a current user typing event (see [SendMessageAction](https://docs.madelineproto.xyz/API_docs/types/SendMessageAction.html) for all event types) to a conversation partner or group.
     *
     * @param array{_: 'sendMessageTypingAction'}|array{_: 'sendMessageCancelAction'}|array{_: 'sendMessageRecordVideoAction'}|array{_: 'sendMessageUploadVideoAction', progress?: int}|array{_: 'sendMessageRecordAudioAction'}|array{_: 'sendMessageUploadAudioAction', progress?: int}|array{_: 'sendMessageUploadPhotoAction', progress?: int}|array{_: 'sendMessageUploadDocumentAction', progress?: int}|array{_: 'sendMessageGeoLocationAction'}|array{_: 'sendMessageChooseContactAction'}|array{_: 'sendMessageGamePlayAction'}|array{_: 'sendMessageRecordRoundAction'}|array{_: 'sendMessageUploadRoundAction', progress?: int}|array{_: 'speakingInGroupCallAction'}|array{_: 'sendMessageHistoryImportAction', progress?: int}|array{_: 'sendMessageChooseStickerAction'}|array{_: 'sendMessageEmojiInteraction', interaction: mixed, emoticon?: string, msg_id?: int}|array{_: 'sendMessageEmojiInteractionSeen', emoticon?: string}|array{_: 'sendMessageUploadVideoAction'}|array{_: 'sendMessageUploadAudioAction'}|array{_: 'sendMessageUploadPhotoAction'}|array{_: 'sendMessageUploadDocumentAction'}|array{_: 'sendMessageUploadRoundAction'} $action Type of action @see https://docs.madelineproto.xyz/API_docs/types/SendMessageAction.html
     * @param array|int|string $peer Target user or group @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $top_msg_id [Topic ID](https://core.telegram.org/api/threads)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setTyping(array $action, array|int|string|null $peer = null, int|null $top_msg_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Sends a message to a chat.
     *
     * @param bool $no_webpage Set this flag to disable generation of the webpage preview
     * @param bool $silent Send this message silently (no notifications for the receivers)
     * @param bool $background Send this message as background message
     * @param bool $clear_draft Clear the draft field
     * @param bool $noforwards Only for bots, disallows forwarding and saving of the messages, even if the destination chat doesn't have [content protection](https://telegram.org/blog/protected-content-delete-by-date-and-more) enabled
     * @param bool $update_stickersets_order Whether to move used stickersets to top, [see here for more info on this flag »](https://core.telegram.org/api/stickers#recent-stickersets)
     * @param bool $invert_media If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
     * @param array|int|string $peer The destination where the message will be sent @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $reply_to_msg_id ID Of message to reply to
     * @param int $top_msg_id This field must contain the topic ID only when replying to messages in forum topics different from the "General" topic (i.e. reply_to_msg_id is set and reply_to_msg_id != topicID and topicID != 1).
     * @param array{_: 'inputReplyToMessage', reply_to_msg_id?: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer?: array|int|string, story_id?: int} $reply_to If set, indicates that the message should be sent in reply to the specified message or story. @see https://docs.madelineproto.xyz/API_docs/types/InputReplyTo.html
     * @param string $message The message
     * @param array $reply_markup Reply markup for sending bot buttons @see https://docs.madelineproto.xyz/API_docs/types/ReplyMarkup.html
     * @param list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}> $entities Array of Message [entities](https://core.telegram.org/api/entities) for sending styled text @see https://docs.madelineproto.xyz/API_docs/types/MessageEntity.html
     * @param \danog\MadelineProto\ParseMode $parse_mode Whether to parse HTML or Markdown markup in the message
     * @param int $schedule_date Scheduled message date for [scheduled messages](https://core.telegram.org/api/scheduled-messages)
     * @param array|int|string $send_as Send this message as the specified peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array{_: 'inputQuickReplyShortcut', shortcut?: string}|array{_: 'inputQuickReplyShortcutId', shortcut_id?: int} $quick_reply_shortcut @see https://docs.madelineproto.xyz/API_docs/types/InputQuickReplyShortcut.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendMessage(bool|null $no_webpage = null, bool|null $silent = null, bool|null $background = null, bool|null $clear_draft = null, bool|null $noforwards = null, bool|null $update_stickersets_order = null, bool|null $invert_media = null, array|int|string|null $peer = null, int $reply_to_msg_id = 0, int $top_msg_id = 0, array|null $reply_to = null, string|null $message = '', array|null $reply_markup = null, array|null $entities = null, \danog\MadelineProto\ParseMode $parse_mode = \danog\MadelineProto\ParseMode::TEXT, int|null $schedule_date = null, array|int|string|null $send_as = null, array|null $quick_reply_shortcut = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Send a media.
     *
     * @param bool $silent Send message silently (no notification should be triggered)
     * @param bool $background Send message in background
     * @param bool $clear_draft Clear the draft
     * @param bool $noforwards Only for bots, disallows forwarding and saving of the messages, even if the destination chat doesn't have [content protection](https://telegram.org/blog/protected-content-delete-by-date-and-more) enabled
     * @param bool $update_stickersets_order Whether to move used stickersets to top, [see here for more info on this flag »](https://core.telegram.org/api/stickers#recent-stickersets)
     * @param bool $invert_media If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
     * @param array|int|string $peer Destination @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $reply_to_msg_id ID Of message to reply to
     * @param int $top_msg_id This field must contain the topic ID only when replying to messages in forum topics different from the "General" topic (i.e. reply_to_msg_id is set and reply_to_msg_id != topicID and topicID != 1).
     * @param array{_: 'inputReplyToMessage', reply_to_msg_id?: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer?: array|int|string, story_id?: int} $reply_to If set, indicates that the message should be sent in reply to the specified message or story. @see https://docs.madelineproto.xyz/API_docs/types/InputReplyTo.html
     * @param \danog\MadelineProto\EventHandler\Media|string|array $media Attached media @see https://docs.madelineproto.xyz/API_docs/types/InputMedia.html
     * @param string $message Caption
     * @param array $reply_markup Reply markup for bot keyboards @see https://docs.madelineproto.xyz/API_docs/types/ReplyMarkup.html
     * @param list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}> $entities Array of Message [entities](https://core.telegram.org/api/entities) for styled text @see https://docs.madelineproto.xyz/API_docs/types/MessageEntity.html
     * @param \danog\MadelineProto\ParseMode $parse_mode Whether to parse HTML or Markdown markup in the message
     * @param int $schedule_date Scheduled message date for [scheduled messages](https://core.telegram.org/api/scheduled-messages)
     * @param array|int|string $send_as Send this message as the specified peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array{_: 'inputQuickReplyShortcut', shortcut?: string}|array{_: 'inputQuickReplyShortcutId', shortcut_id?: int} $quick_reply_shortcut @see https://docs.madelineproto.xyz/API_docs/types/InputQuickReplyShortcut.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendMedia(bool|null $silent = null, bool|null $background = null, bool|null $clear_draft = null, bool|null $noforwards = null, bool|null $update_stickersets_order = null, bool|null $invert_media = null, array|int|string|null $peer = null, int $reply_to_msg_id = 0, int $top_msg_id = 0, array|null $reply_to = null, \danog\MadelineProto\EventHandler\Media|array|string|null $media = null, string|null $message = '', array|null $reply_markup = null, array|null $entities = null, \danog\MadelineProto\ParseMode $parse_mode = \danog\MadelineProto\ParseMode::TEXT, int|null $schedule_date = null, array|int|string|null $send_as = null, array|null $quick_reply_shortcut = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Forwards messages by their IDs.
     *
     * @param bool $silent Whether to send messages silently (no notification will be triggered on the destination clients)
     * @param bool $background Whether to send the message in background
     * @param bool $with_my_score When forwarding games, whether to include your score in the game
     * @param bool $drop_author Whether to forward messages without quoting the original author
     * @param bool $drop_media_captions Whether to strip captions from media
     * @param bool $noforwards Only for bots, disallows further re-forwarding and saving of the messages, even if the destination chat doesn't have [content protection](https://telegram.org/blog/protected-content-delete-by-date-and-more) enabled
     * @param array|int|string $from_peer Source of messages @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id IDs of messages
     * @param array|int|string $to_peer Destination peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $top_msg_id Destination [forum topic](https://core.telegram.org/api/forum#forum-topics)
     * @param int $schedule_date Scheduled message date for scheduled messages
     * @param array|int|string $send_as Forward the messages as the specified peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array{_: 'inputQuickReplyShortcut', shortcut?: string}|array{_: 'inputQuickReplyShortcutId', shortcut_id?: int} $quick_reply_shortcut @see https://docs.madelineproto.xyz/API_docs/types/InputQuickReplyShortcut.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function forwardMessages(bool|null $silent = null, bool|null $background = null, bool|null $with_my_score = null, bool|null $drop_author = null, bool|null $drop_media_captions = null, bool|null $noforwards = null, array|int|string|null $from_peer = null, array $id = [], array|int|string|null $to_peer = null, int|null $top_msg_id = null, int|null $schedule_date = null, array|int|string|null $send_as = null, array|null $quick_reply_shortcut = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Report a new incoming chat for spam, if the [peer settings](https://docs.madelineproto.xyz/API_docs/constructors/peerSettings.html) of the chat allow us to do that.
     *
     * @param array|int|string $peer Peer to report @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function reportSpam(array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get peer settings.
     *
     * @param array|int|string $peer The peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.peerSettings', settings: array{_: 'peerSettings', report_spam: bool, add_contact: bool, block_contact: bool, share_contact: bool, need_contacts_exception: bool, report_geo: bool, autoarchived: bool, invite_members: bool, request_chat_broadcast: bool, business_bot_paused: bool, business_bot_can_reply: bool, geo_distance?: int, request_chat_title?: string, request_chat_date?: int, business_bot_id?: int, business_bot_manage_url?: string}, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.PeerSettings.html
     */
    public function getPeerSettings(array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Report a message in a chat for violation of telegram's Terms of Service.
     *
     * @param array{_: 'inputReportReasonSpam'}|array{_: 'inputReportReasonViolence'}|array{_: 'inputReportReasonPornography'}|array{_: 'inputReportReasonChildAbuse'}|array{_: 'inputReportReasonOther'}|array{_: 'inputReportReasonCopyright'}|array{_: 'inputReportReasonGeoIrrelevant'}|array{_: 'inputReportReasonFake'}|array{_: 'inputReportReasonIllegalDrugs'}|array{_: 'inputReportReasonPersonalDetails'} $reason Why are these messages being reported @see https://docs.madelineproto.xyz/API_docs/types/ReportReason.html
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id IDs of messages to report
     * @param string $message Comment for report moderation
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function report(array $reason, array|int|string|null $peer = null, array $id = [], string|null $message = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Returns chat basic info on their IDs.
     *
     * @param list<int>|array<never, never> $id List of chat IDs
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.chats', chats: list<array|int|string>}|array{_: 'messages.chatsSlice', count: int, chats: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Chats.html
     */
    public function getChats(array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Changes chat name and sends a service message on it.
     *
     * @param array|int|string $chat_id Chat ID @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $title New chat name, different from the old one
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editChatTitle(array|int|string|null $chat_id = null, string|null $title = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Changes chat photo and sends a service message on it.
     *
     * @param array|int|string $chat_id Chat ID @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array{_: 'inputChatPhotoEmpty'}|array{_: 'inputChatUploadedPhoto', file?: mixed, video?: mixed, video_start_ts?: float, video_emoji_markup?: array{_: 'videoSize', type?: string, w?: int, h?: int, size?: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id?: int, background_colors?: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset?: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id?: int, access_hash?: int}|array{_: 'inputStickerSetShortName', short_name?: string}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon?: string}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}|array{_: 'inputStickerSetEmojiChannelDefaultStatuses'}, sticker_id?: int, background_colors?: list<int>}}|array{_: 'inputChatPhoto', id?: array} $photo Photo to be set @see https://docs.madelineproto.xyz/API_docs/types/InputChatPhoto.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editChatPhoto(array|int|string|null $chat_id = null, array|null $photo = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Adds a user to a chat and sends a service message on it.
     *
     * May also return 0-N updates of type [updateGroupInvitePrivacyForbidden](https://docs.madelineproto.xyz/API_docs/constructors/updateGroupInvitePrivacyForbidden.html): it indicates we couldn't add a user to a chat because of their privacy settings; if required, an [invite link](https://core.telegram.org/api/invites) can be shared with the user, instead.
     *
     * @param array|int|string $chat_id Chat ID @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $user_id User ID to be added @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param int $fwd_limit Number of last messages to be forwarded
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.invitedUsers', updates: array, missing_invitees: list<array{_: 'missingInvitee', premium_would_allow_invite: bool, premium_required_for_pm: bool, user_id: int}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.InvitedUsers.html
     */
    public function addChatUser(array|int|string|null $chat_id = null, array|int|string|null $user_id = null, int|null $fwd_limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Deletes a user from a chat and sends a service message on it.
     *
     * @param bool $revoke_history Remove the entire chat history of the specified user in this chat.
     * @param array|int|string $chat_id Chat ID @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $user_id User ID to be deleted @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function deleteChatUser(bool|null $revoke_history = null, array|int|string|null $chat_id = null, array|int|string|null $user_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Creates a new chat.
     *
     * May also return 0-N updates of type [updateGroupInvitePrivacyForbidden](https://docs.madelineproto.xyz/API_docs/constructors/updateGroupInvitePrivacyForbidden.html): it indicates we couldn't add a user to a chat because of their privacy settings; if required, an [invite link](https://core.telegram.org/api/invites) can be shared with the user, instead.
     *
     * @param list<array|int|string>|array<never, never> $users Array of List of user IDs to be invited @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param string $title Chat name
     * @param int $ttl_period Time-to-live of all messages that will be sent in the chat: once message.date+message.ttl\_period === time(), the message will be deleted on the server, and must be deleted locally as well. You can use [messages.setDefaultHistoryTTL](https://docs.madelineproto.xyz/API_docs/methods/messages.setDefaultHistoryTTL.html) to edit this value later.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.invitedUsers', updates: array, missing_invitees: list<array{_: 'missingInvitee', premium_would_allow_invite: bool, premium_required_for_pm: bool, user_id: int}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.InvitedUsers.html
     */
    public function createChat(array $users = [], string|null $title = '', int|null $ttl_period = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Send typing event by the current user to a secret chat.
     *
     * @param array $peer Secret chat ID @see https://docs.madelineproto.xyz/API_docs/types/InputEncryptedChat.html
     * @param bool $typing Typing.<br>**Possible values**:<br>[(boolTrue)](https://docs.madelineproto.xyz/API_docs/constructors/boolTrue.html), if the user started typing and more than **5 seconds** have passed since the last request<br>[(boolFalse)](https://docs.madelineproto.xyz/API_docs/constructors/boolFalse.html), if the user stopped typing
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setEncryptedTyping(array $peer, bool $typing, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Marks message history within a secret chat as read.
     *
     * @param array $peer Secret chat ID @see https://docs.madelineproto.xyz/API_docs/types/InputEncryptedChat.html
     * @param int $max_date Maximum date value for received messages in history
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function readEncryptedHistory(array $peer, int|null $max_date = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Sends a text message to a secret chat.
     *
     * @param array $peer Secret chat ID @see https://docs.madelineproto.xyz/API_docs/types/InputEncryptedChat.html
     * @param array{_: 'decryptedMessage', media: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, message?: string}|array{_: 'decryptedMessageService', action: array{_: 'decryptedMessageActionSetMessageTTL', ttl_seconds?: array}|array{_: 'decryptedMessageActionReadMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionDeleteMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionScreenshotMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionFlushHistory'}|array{_: 'decryptedMessageActionResend', start_seq_no?: array, end_seq_no?: array}|array{_: 'decryptedMessageActionNotifyLayer', layer?: array}|array{_: 'decryptedMessageActionTyping', action: array}|array{_: 'decryptedMessageActionRequestKey', exchange_id?: array, g_a?: array}|array{_: 'decryptedMessageActionAcceptKey', exchange_id?: array, g_b?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionAbortKey', exchange_id?: array}|array{_: 'decryptedMessageActionCommitKey', exchange_id?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionNoop'}}|array{_: 'decryptedMessage', media: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, ttl?: int, message?: string}|array{_: 'decryptedMessageService', action: array{_: 'decryptedMessageActionSetMessageTTL', ttl_seconds?: array}|array{_: 'decryptedMessageActionReadMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionDeleteMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionScreenshotMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionFlushHistory'}|array{_: 'decryptedMessageActionResend', start_seq_no?: array, end_seq_no?: array}|array{_: 'decryptedMessageActionNotifyLayer', layer?: array}|array{_: 'decryptedMessageActionTyping', action: array}|array{_: 'decryptedMessageActionRequestKey', exchange_id?: array, g_a?: array}|array{_: 'decryptedMessageActionAcceptKey', exchange_id?: array, g_b?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionAbortKey', exchange_id?: array}|array{_: 'decryptedMessageActionCommitKey', exchange_id?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionNoop'}}|array{_: 'decryptedMessage', ttl?: int, message?: string, media?: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, entities?: list<array{_: 'messageEntityUnknown', offset?: array, length?: array}|array{_: 'messageEntityMention', offset?: array, length?: array}|array{_: 'messageEntityHashtag', offset?: array, length?: array}|array{_: 'messageEntityBotCommand', offset?: array, length?: array}|array{_: 'messageEntityUrl', offset?: array, length?: array}|array{_: 'messageEntityEmail', offset?: array, length?: array}|array{_: 'messageEntityBold', offset?: array, length?: array}|array{_: 'messageEntityItalic', offset?: array, length?: array}|array{_: 'messageEntityCode', offset?: array, length?: array}|array{_: 'messageEntityPre', offset?: array, length?: array, language?: array}|array{_: 'messageEntityTextUrl', offset?: array, length?: array, url?: array}|array{_: 'messageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'inputMessageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'messageEntityPhone', offset?: array, length?: array}|array{_: 'messageEntityCashtag', offset?: array, length?: array}|array{_: 'messageEntityUnderline', offset?: array, length?: array}|array{_: 'messageEntityStrike', offset?: array, length?: array}|array{_: 'messageEntityBankCard', offset?: array, length?: array}|array{_: 'messageEntitySpoiler', offset?: array, length?: array}|array{_: 'messageEntityCustomEmoji', offset?: array, length?: array, document_id?: array}|array{_: 'messageEntityBlockquote', offset?: array, length?: array}>, via_bot_name?: string, reply_to_random_id?: int}|array{_: 'decryptedMessage', no_webpage?: bool, silent?: bool, ttl?: int, message?: string, media?: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, entities?: list<array{_: 'messageEntityUnknown', offset?: array, length?: array}|array{_: 'messageEntityMention', offset?: array, length?: array}|array{_: 'messageEntityHashtag', offset?: array, length?: array}|array{_: 'messageEntityBotCommand', offset?: array, length?: array}|array{_: 'messageEntityUrl', offset?: array, length?: array}|array{_: 'messageEntityEmail', offset?: array, length?: array}|array{_: 'messageEntityBold', offset?: array, length?: array}|array{_: 'messageEntityItalic', offset?: array, length?: array}|array{_: 'messageEntityCode', offset?: array, length?: array}|array{_: 'messageEntityPre', offset?: array, length?: array, language?: array}|array{_: 'messageEntityTextUrl', offset?: array, length?: array, url?: array}|array{_: 'messageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'inputMessageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'messageEntityPhone', offset?: array, length?: array}|array{_: 'messageEntityCashtag', offset?: array, length?: array}|array{_: 'messageEntityUnderline', offset?: array, length?: array}|array{_: 'messageEntityStrike', offset?: array, length?: array}|array{_: 'messageEntityBankCard', offset?: array, length?: array}|array{_: 'messageEntitySpoiler', offset?: array, length?: array}|array{_: 'messageEntityCustomEmoji', offset?: array, length?: array, document_id?: array}|array{_: 'messageEntityBlockquote', offset?: array, length?: array}>, via_bot_name?: string, reply_to_random_id?: int, grouped_id?: int} $message TL-serialization of [DecryptedMessage](https://docs.madelineproto.xyz/API_docs/types/DecryptedMessage.html) type, encrypted with a key that was created during chat initialization @see https://docs.madelineproto.xyz/API_docs/types/DecryptedMessage.html
     * @param bool $silent Send encrypted message without a notification
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.sentEncryptedMessage', date: int}|array{_: 'messages.sentEncryptedFile', date: int, file: array{_: 'encryptedFileEmpty'}|array{_: 'encryptedFile', id: int, access_hash: int, size: int, dc_id: int, key_fingerprint: int}} @see https://docs.madelineproto.xyz/API_docs/types/messages.SentEncryptedMessage.html
     */
    public function sendEncrypted(array $peer, array $message, bool|null $silent = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Sends a message with a file attachment to a secret chat.
     *
     * @param array $peer Secret chat ID @see https://docs.madelineproto.xyz/API_docs/types/InputEncryptedChat.html
     * @param array{_: 'decryptedMessage', media: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, message?: string}|array{_: 'decryptedMessageService', action: array{_: 'decryptedMessageActionSetMessageTTL', ttl_seconds?: array}|array{_: 'decryptedMessageActionReadMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionDeleteMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionScreenshotMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionFlushHistory'}|array{_: 'decryptedMessageActionResend', start_seq_no?: array, end_seq_no?: array}|array{_: 'decryptedMessageActionNotifyLayer', layer?: array}|array{_: 'decryptedMessageActionTyping', action: array}|array{_: 'decryptedMessageActionRequestKey', exchange_id?: array, g_a?: array}|array{_: 'decryptedMessageActionAcceptKey', exchange_id?: array, g_b?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionAbortKey', exchange_id?: array}|array{_: 'decryptedMessageActionCommitKey', exchange_id?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionNoop'}}|array{_: 'decryptedMessage', media: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, ttl?: int, message?: string}|array{_: 'decryptedMessageService', action: array{_: 'decryptedMessageActionSetMessageTTL', ttl_seconds?: array}|array{_: 'decryptedMessageActionReadMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionDeleteMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionScreenshotMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionFlushHistory'}|array{_: 'decryptedMessageActionResend', start_seq_no?: array, end_seq_no?: array}|array{_: 'decryptedMessageActionNotifyLayer', layer?: array}|array{_: 'decryptedMessageActionTyping', action: array}|array{_: 'decryptedMessageActionRequestKey', exchange_id?: array, g_a?: array}|array{_: 'decryptedMessageActionAcceptKey', exchange_id?: array, g_b?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionAbortKey', exchange_id?: array}|array{_: 'decryptedMessageActionCommitKey', exchange_id?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionNoop'}}|array{_: 'decryptedMessage', ttl?: int, message?: string, media?: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, entities?: list<array{_: 'messageEntityUnknown', offset?: array, length?: array}|array{_: 'messageEntityMention', offset?: array, length?: array}|array{_: 'messageEntityHashtag', offset?: array, length?: array}|array{_: 'messageEntityBotCommand', offset?: array, length?: array}|array{_: 'messageEntityUrl', offset?: array, length?: array}|array{_: 'messageEntityEmail', offset?: array, length?: array}|array{_: 'messageEntityBold', offset?: array, length?: array}|array{_: 'messageEntityItalic', offset?: array, length?: array}|array{_: 'messageEntityCode', offset?: array, length?: array}|array{_: 'messageEntityPre', offset?: array, length?: array, language?: array}|array{_: 'messageEntityTextUrl', offset?: array, length?: array, url?: array}|array{_: 'messageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'inputMessageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'messageEntityPhone', offset?: array, length?: array}|array{_: 'messageEntityCashtag', offset?: array, length?: array}|array{_: 'messageEntityUnderline', offset?: array, length?: array}|array{_: 'messageEntityStrike', offset?: array, length?: array}|array{_: 'messageEntityBankCard', offset?: array, length?: array}|array{_: 'messageEntitySpoiler', offset?: array, length?: array}|array{_: 'messageEntityCustomEmoji', offset?: array, length?: array, document_id?: array}|array{_: 'messageEntityBlockquote', offset?: array, length?: array}>, via_bot_name?: string, reply_to_random_id?: int}|array{_: 'decryptedMessage', no_webpage?: bool, silent?: bool, ttl?: int, message?: string, media?: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, entities?: list<array{_: 'messageEntityUnknown', offset?: array, length?: array}|array{_: 'messageEntityMention', offset?: array, length?: array}|array{_: 'messageEntityHashtag', offset?: array, length?: array}|array{_: 'messageEntityBotCommand', offset?: array, length?: array}|array{_: 'messageEntityUrl', offset?: array, length?: array}|array{_: 'messageEntityEmail', offset?: array, length?: array}|array{_: 'messageEntityBold', offset?: array, length?: array}|array{_: 'messageEntityItalic', offset?: array, length?: array}|array{_: 'messageEntityCode', offset?: array, length?: array}|array{_: 'messageEntityPre', offset?: array, length?: array, language?: array}|array{_: 'messageEntityTextUrl', offset?: array, length?: array, url?: array}|array{_: 'messageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'inputMessageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'messageEntityPhone', offset?: array, length?: array}|array{_: 'messageEntityCashtag', offset?: array, length?: array}|array{_: 'messageEntityUnderline', offset?: array, length?: array}|array{_: 'messageEntityStrike', offset?: array, length?: array}|array{_: 'messageEntityBankCard', offset?: array, length?: array}|array{_: 'messageEntitySpoiler', offset?: array, length?: array}|array{_: 'messageEntityCustomEmoji', offset?: array, length?: array, document_id?: array}|array{_: 'messageEntityBlockquote', offset?: array, length?: array}>, via_bot_name?: string, reply_to_random_id?: int, grouped_id?: int} $message TL-serialization of [DecryptedMessage](https://docs.madelineproto.xyz/API_docs/types/DecryptedMessage.html) type, encrypted with a key generated during chat initialization @see https://docs.madelineproto.xyz/API_docs/types/DecryptedMessage.html
     * @param bool $silent Whether to send the file without triggering a notification
     * @param mixed $file File attachment for the secret chat @see https://docs.madelineproto.xyz/API_docs/types/InputEncryptedFile.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.sentEncryptedMessage', date: int}|array{_: 'messages.sentEncryptedFile', date: int, file: array{_: 'encryptedFileEmpty'}|array{_: 'encryptedFile', id: int, access_hash: int, size: int, dc_id: int, key_fingerprint: int}} @see https://docs.madelineproto.xyz/API_docs/types/messages.SentEncryptedMessage.html
     */
    public function sendEncryptedFile(array $peer, array $message, bool|null $silent = null, mixed $file = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Sends a service message to a secret chat.
     *
     * @param array $peer Secret chat ID @see https://docs.madelineproto.xyz/API_docs/types/InputEncryptedChat.html
     * @param array{_: 'decryptedMessage', media: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, message?: string}|array{_: 'decryptedMessageService', action: array{_: 'decryptedMessageActionSetMessageTTL', ttl_seconds?: array}|array{_: 'decryptedMessageActionReadMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionDeleteMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionScreenshotMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionFlushHistory'}|array{_: 'decryptedMessageActionResend', start_seq_no?: array, end_seq_no?: array}|array{_: 'decryptedMessageActionNotifyLayer', layer?: array}|array{_: 'decryptedMessageActionTyping', action: array}|array{_: 'decryptedMessageActionRequestKey', exchange_id?: array, g_a?: array}|array{_: 'decryptedMessageActionAcceptKey', exchange_id?: array, g_b?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionAbortKey', exchange_id?: array}|array{_: 'decryptedMessageActionCommitKey', exchange_id?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionNoop'}}|array{_: 'decryptedMessage', media: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, ttl?: int, message?: string}|array{_: 'decryptedMessageService', action: array{_: 'decryptedMessageActionSetMessageTTL', ttl_seconds?: array}|array{_: 'decryptedMessageActionReadMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionDeleteMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionScreenshotMessages', random_ids?: list<array>}|array{_: 'decryptedMessageActionFlushHistory'}|array{_: 'decryptedMessageActionResend', start_seq_no?: array, end_seq_no?: array}|array{_: 'decryptedMessageActionNotifyLayer', layer?: array}|array{_: 'decryptedMessageActionTyping', action: array}|array{_: 'decryptedMessageActionRequestKey', exchange_id?: array, g_a?: array}|array{_: 'decryptedMessageActionAcceptKey', exchange_id?: array, g_b?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionAbortKey', exchange_id?: array}|array{_: 'decryptedMessageActionCommitKey', exchange_id?: array, key_fingerprint?: array}|array{_: 'decryptedMessageActionNoop'}}|array{_: 'decryptedMessage', ttl?: int, message?: string, media?: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, entities?: list<array{_: 'messageEntityUnknown', offset?: array, length?: array}|array{_: 'messageEntityMention', offset?: array, length?: array}|array{_: 'messageEntityHashtag', offset?: array, length?: array}|array{_: 'messageEntityBotCommand', offset?: array, length?: array}|array{_: 'messageEntityUrl', offset?: array, length?: array}|array{_: 'messageEntityEmail', offset?: array, length?: array}|array{_: 'messageEntityBold', offset?: array, length?: array}|array{_: 'messageEntityItalic', offset?: array, length?: array}|array{_: 'messageEntityCode', offset?: array, length?: array}|array{_: 'messageEntityPre', offset?: array, length?: array, language?: array}|array{_: 'messageEntityTextUrl', offset?: array, length?: array, url?: array}|array{_: 'messageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'inputMessageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'messageEntityPhone', offset?: array, length?: array}|array{_: 'messageEntityCashtag', offset?: array, length?: array}|array{_: 'messageEntityUnderline', offset?: array, length?: array}|array{_: 'messageEntityStrike', offset?: array, length?: array}|array{_: 'messageEntityBankCard', offset?: array, length?: array}|array{_: 'messageEntitySpoiler', offset?: array, length?: array}|array{_: 'messageEntityCustomEmoji', offset?: array, length?: array, document_id?: array}|array{_: 'messageEntityBlockquote', offset?: array, length?: array}>, via_bot_name?: string, reply_to_random_id?: int}|array{_: 'decryptedMessage', no_webpage?: bool, silent?: bool, ttl?: int, message?: string, media?: array{_: 'decryptedMessageMediaEmpty'}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaGeoPoint', lat: array, long: array}|array{_: 'decryptedMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, user_id?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, file_name?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, size?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array}|array{_: 'decryptedMessageMediaAudio', duration?: array, mime_type?: array, size?: array}|array{_: 'decryptedMessageMediaExternalDocument', id?: array, access_hash?: array, date?: array, mime_type?: array, size?: array, thumb?: array, dc_id?: array, attributes?: list<array>}|array{_: 'decryptedMessageMediaPhoto', thumb?: array, thumb_w?: array, thumb_h?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaVideo', thumb?: array, thumb_w?: array, thumb_h?: array, duration?: array, mime_type?: array, w?: array, h?: array, size?: array, caption?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}|array{_: 'decryptedMessageMediaVenue', lat: array, long: array, title?: array, address?: array, provider?: array, venue_id?: array}|array{_: 'decryptedMessageMediaWebPage', url?: array}|array{_: 'decryptedMessageMediaDocument', thumb?: array, thumb_w?: array, thumb_h?: array, mime_type?: array, size?: array, attributes?: list<array>, caption?: array}, entities?: list<array{_: 'messageEntityUnknown', offset?: array, length?: array}|array{_: 'messageEntityMention', offset?: array, length?: array}|array{_: 'messageEntityHashtag', offset?: array, length?: array}|array{_: 'messageEntityBotCommand', offset?: array, length?: array}|array{_: 'messageEntityUrl', offset?: array, length?: array}|array{_: 'messageEntityEmail', offset?: array, length?: array}|array{_: 'messageEntityBold', offset?: array, length?: array}|array{_: 'messageEntityItalic', offset?: array, length?: array}|array{_: 'messageEntityCode', offset?: array, length?: array}|array{_: 'messageEntityPre', offset?: array, length?: array, language?: array}|array{_: 'messageEntityTextUrl', offset?: array, length?: array, url?: array}|array{_: 'messageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'inputMessageEntityMentionName', offset?: array, length?: array, user_id?: array}|array{_: 'messageEntityPhone', offset?: array, length?: array}|array{_: 'messageEntityCashtag', offset?: array, length?: array}|array{_: 'messageEntityUnderline', offset?: array, length?: array}|array{_: 'messageEntityStrike', offset?: array, length?: array}|array{_: 'messageEntityBankCard', offset?: array, length?: array}|array{_: 'messageEntitySpoiler', offset?: array, length?: array}|array{_: 'messageEntityCustomEmoji', offset?: array, length?: array, document_id?: array}|array{_: 'messageEntityBlockquote', offset?: array, length?: array}>, via_bot_name?: string, reply_to_random_id?: int, grouped_id?: int} $message TL-serialization of  [DecryptedMessage](https://docs.madelineproto.xyz/API_docs/types/DecryptedMessage.html) type, encrypted with a key generated during chat initialization @see https://docs.madelineproto.xyz/API_docs/types/DecryptedMessage.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.sentEncryptedMessage', date: int}|array{_: 'messages.sentEncryptedFile', date: int, file: array{_: 'encryptedFileEmpty'}|array{_: 'encryptedFile', id: int, access_hash: int, size: int, dc_id: int, key_fingerprint: int}} @see https://docs.madelineproto.xyz/API_docs/types/messages.SentEncryptedMessage.html
     */
    public function sendEncryptedService(array $peer, array $message, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Report a secret chat for spam.
     *
     * @param array $peer The secret chat to report @see https://docs.madelineproto.xyz/API_docs/types/InputEncryptedChat.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function reportEncryptedSpam(array $peer, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Notifies the sender about the recipient having listened a voice message or watched a video.
     *
     * @param list<int>|array<never, never> $id Message ID list
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedMessages', pts: int, pts_count: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedMessages.html
     */
    public function readMessageContents(array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get stickers by emoji.
     *
     * @param string $emoticon The emoji
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.stickersNotModified'}|array{_: 'messages.stickers', hash: list<int>, stickers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Stickers.html
     */
    public function getStickers(string|null $emoticon = '', array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get all installed stickers.
     *
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.allStickersNotModified'}|array{_: 'messages.allStickers', hash: list<int>, sets: list<array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.AllStickers.html
     */
    public function getAllStickers(array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get preview of webpage.
     *
     * @param string $message Message from which to extract the preview
     * @param list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}> $entities Array of [Message entities for styled text](https://core.telegram.org/api/entities) @see https://docs.madelineproto.xyz/API_docs/types/MessageEntity.html
     * @param \danog\MadelineProto\ParseMode $parse_mode Whether to parse HTML or Markdown markup in the message
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}|array{_: 'messageExtendedMedia', media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}|array{_: 'storyItem', pinned: array, public: array, close_friends: array, min: array, noforwards: array, edited: array, contacts: array, selected_contacts: array, out: array, id: array, date: array, from_id?: array, fwd_from?: array, expire_date: array, caption?: array, entities?: list<array>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, media_areas?: list<array>, privacy?: list<array>, views?: array, sent_reaction?: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int} @see https://docs.madelineproto.xyz/API_docs/types/MessageMedia.html
     */
    public function getWebPagePreview(string|null $message = '', array|null $entities = null, \danog\MadelineProto\ParseMode $parse_mode = \danog\MadelineProto\ParseMode::TEXT, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Export an invite link for a chat.
     *
     * @param bool $legacy_revoke_permanent Legacy flag, reproducing legacy behavior of this method: if set, revokes all previous links before creating a new one. Kept for bot API BC, should not be used by modern clients.
     * @param bool $request_needed Whether admin confirmation is required before admitting each separate user into the chat
     * @param array|int|string $peer Chat @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $expire_date Expiration date
     * @param int $usage_limit Maximum number of users that can join using this link
     * @param string $title Description of the invite link, visible only to administrators
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'chatInviteExported', revoked: bool, permanent: bool, request_needed: bool, link: string, admin_id: int, date: int, start_date?: int, expire_date?: int, usage_limit?: int, usage?: int, requested?: int, title?: string}|array{_: 'chatInvitePublicJoinRequests'} @see https://docs.madelineproto.xyz/API_docs/types/ExportedChatInvite.html
     */
    public function exportChatInvite(bool|null $legacy_revoke_permanent = null, bool|null $request_needed = null, array|int|string|null $peer = null, int|null $expire_date = null, int|null $usage_limit = null, string|null $title = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Check the validity of a chat invite link and get basic info about it.
     *
     * @param string $hash Invite hash from [chat invite deep link »](https://core.telegram.org/api/links#chat-invite-links).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'chatInviteAlready', chat: array|int|string}|array{_: 'chatInvite', channel: bool, broadcast: bool, public: bool, megagroup: bool, request_needed: bool, verified: bool, scam: bool, fake: bool, title: string, about?: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, participants_count: int, participants?: list<array|int|string>, color: int}|array{_: 'chatInvitePeek', chat: array|int|string, expires: int} @see https://docs.madelineproto.xyz/API_docs/types/ChatInvite.html
     */
    public function checkChatInvite(string|null $hash = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Import a chat invite and join a private chat/supergroup/channel.
     *
     * @param string $hash `hash` from a [chat invite deep link](https://core.telegram.org/api/links#chat-invite-links)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function importChatInvite(string|null $hash = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get info about a stickerset.
     *
     * @param array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id?: int, access_hash?: int}|array{_: 'inputStickerSetShortName', short_name?: string}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon?: string}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}|array{_: 'inputStickerSetEmojiChannelDefaultStatuses'} $stickerset Stickerset @see https://docs.madelineproto.xyz/API_docs/types/InputStickerSet.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.stickerSet', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, keywords: list<array{_: 'stickerKeyword', document_id: int, keyword: list<string>}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'messages.stickerSetNotModified'} @see https://docs.madelineproto.xyz/API_docs/types/messages.StickerSet.html
     */
    public function getStickerSet(array|null $stickerset = null, int|null $hash = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Install a stickerset.
     *
     * @param bool $archived Whether to archive stickerset
     * @param array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id?: int, access_hash?: int}|array{_: 'inputStickerSetShortName', short_name?: string}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon?: string}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}|array{_: 'inputStickerSetEmojiChannelDefaultStatuses'} $stickerset Stickerset to install @see https://docs.madelineproto.xyz/API_docs/types/InputStickerSet.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.stickerSetInstallResultSuccess'}|array{_: 'messages.stickerSetInstallResultArchive', sets: list<array{_: 'stickerSetCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, cover: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}|array{_: 'stickerSetMultiCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, covers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetFullCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, keywords: list<array{_: 'stickerKeyword', document_id: int, keyword: list<string>}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetNoCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.StickerSetInstallResult.html
     */
    public function installStickerSet(bool $archived, array|null $stickerset = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Uninstall a stickerset.
     *
     * @param array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id?: int, access_hash?: int}|array{_: 'inputStickerSetShortName', short_name?: string}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon?: string}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}|array{_: 'inputStickerSetEmojiChannelDefaultStatuses'} $stickerset The stickerset to uninstall @see https://docs.madelineproto.xyz/API_docs/types/InputStickerSet.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function uninstallStickerSet(array|null $stickerset = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Start a conversation with a bot using a [deep linking parameter](https://core.telegram.org/api/links#bot-links).
     *
     * @param array|int|string $bot The bot @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param array|int|string $peer The chat where to start the bot, can be the bot's private chat or a group @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $start_param [Deep linking parameter](https://core.telegram.org/api/links#bot-links)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function startBot(array|int|string|null $bot = null, array|int|string|null $peer = null, string|null $start_param = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get and increase the view counter of a message sent or forwarded from a [channel](https://core.telegram.org/api/channel).
     *
     * @param bool $increment Whether to mark the message as viewed and increment the view counter
     * @param array|int|string $peer Peer where the message was found @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id ID of message
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messageViews', views: list<array{_: 'messageViews', views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}}>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.MessageViews.html
     */
    public function getMessagesViews(bool $increment, array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Make a user admin in a [basic group](https://core.telegram.org/api/channel#basic-groups).
     *
     * @param bool $is_admin Whether to make them admin
     * @param array|int|string $chat_id The ID of the group @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $user_id The user to make admin @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function editChatAdmin(bool $is_admin, array|int|string|null $chat_id = null, array|int|string|null $user_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Turn a [basic group into a supergroup](https://core.telegram.org/api/channel#migration).
     *
     * @param array|int|string $chat_id [Basic group](https://core.telegram.org/api/channel#basic-groups) to migrate @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function migrateChat(array|int|string|null $chat_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Search for messages and peers globally.
     *
     * @param array{_: 'inputMessagesFilterEmpty'}|array{_: 'inputMessagesFilterPhotos'}|array{_: 'inputMessagesFilterVideo'}|array{_: 'inputMessagesFilterPhotoVideo'}|array{_: 'inputMessagesFilterDocument'}|array{_: 'inputMessagesFilterUrl'}|array{_: 'inputMessagesFilterGif'}|array{_: 'inputMessagesFilterVoice'}|array{_: 'inputMessagesFilterMusic'}|array{_: 'inputMessagesFilterChatPhotos'}|array{_: 'inputMessagesFilterPhoneCalls', missed?: bool}|array{_: 'inputMessagesFilterRoundVoice'}|array{_: 'inputMessagesFilterRoundVideo'}|array{_: 'inputMessagesFilterMyMentions'}|array{_: 'inputMessagesFilterGeo'}|array{_: 'inputMessagesFilterContacts'}|array{_: 'inputMessagesFilterPinned'} $filter Global search filter @see https://docs.madelineproto.xyz/API_docs/types/MessagesFilter.html
     * @param bool $broadcasts_only
     * @param int $folder_id [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
     * @param string $q Query
     * @param int $min_date If a positive value was specified, the method will return only messages with date bigger than min\_date
     * @param int $max_date If a positive value was transferred, the method will return only messages with date smaller than max\_date
     * @param int $offset_rate Initially 0, then set to the [`next_rate` parameter of messages.messagesSlice](https://docs.madelineproto.xyz/API_docs/constructors/messages.messagesSlice.html)
     * @param array|int|string $offset_peer [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets) @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $limit [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function searchGlobal(array $filter, bool|null $broadcasts_only = null, int|null $folder_id = null, string|null $q = '', int|null $min_date = 0, int|null $max_date = 0, int|null $offset_rate = 0, array|int|string|null $offset_peer = null, int|null $offset_id = 0, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Reorder installed stickersets.
     *
     * @param bool $masks Reorder mask stickersets
     * @param bool $emojis Reorder [custom emoji stickersets](https://core.telegram.org/api/custom-emoji)
     * @param list<int>|array<never, never> $order New stickerset order by stickerset IDs
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function reorderStickerSets(bool|null $masks = null, bool|null $emojis = null, array $order = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get a document by its SHA256 hash, mainly used for gifs.
     *
     * @param string $sha256 SHA256 of file
     * @param int $size Size of the file in bytes
     * @param string $mime_type Mime type
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>} @see https://docs.madelineproto.xyz/API_docs/types/Document.html
     */
    public function getDocumentByHash(string|null $sha256 = '', int|null $size = 0, string|null $mime_type = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get saved GIFs.
     *
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.savedGifsNotModified'}|array{_: 'messages.savedGifs', hash: list<int>, gifs: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.SavedGifs.html
     */
    public function getSavedGifs(array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Add GIF to saved gifs list.
     *
     * @param bool $unsave Whether to remove GIF from saved gifs list
     * @param array $id GIF to save @see https://docs.madelineproto.xyz/API_docs/types/InputDocument.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function saveGif(bool $unsave, array|null $id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Query an inline bot.
     *
     * @param array|int|string $bot The bot to query @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param array|int|string $peer The currently opened chat @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array{_: 'inputGeoPointEmpty'}|array{_: 'inputGeoPoint', lat: float, long: float, accuracy_radius?: int} $geo_point The geolocation, if requested @see https://docs.madelineproto.xyz/API_docs/types/InputGeoPoint.html
     * @param string $query The query
     * @param string $offset The offset within the results, will be passed directly as-is to the bot.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.botResults', gallery: bool, query_id: int, next_offset?: string, switch_pm?: array{_: 'inlineBotSwitchPM', text: array, start_param: array}, switch_webview?: array{_: 'inlineBotWebView', text: array, url: array}, results: list<array{_: 'botInlineResult', send_message: array, id: array, type: array, title?: array, description?: array, url?: array, thumb?: array, content?: array}|array{_: 'botInlineMediaResult', send_message: array, id: array, type: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, title?: array, description?: array}>, cache_time: int, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.BotResults.html
     */
    public function getInlineBotResults(array|int|string|null $bot = null, array|int|string|null $peer = null, array|null $geo_point = null, string|null $query = '', string|null $offset = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Answer an inline query, for bots only.
     *
     * @param bool $gallery Set this flag if the results are composed of media files
     * @param bool $private Set this flag if results may be cached on the server side only for the user that sent the query. By default, results may be returned to any user who sends the same query
     * @param int $query_id Unique identifier for the answered query
     * @param list<array{_: 'inputBotInlineResult', send_message: array{_: 'inputBotInlineMessageMediaAuto', invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageText', no_webpage?: array, invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaGeo', geo_point?: array, heading?: array, period?: array, proximity_notification_radius?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaVenue', geo_point?: array, title?: array, address?: array, provider?: array, venue_id?: array, venue_type?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, vcard?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageGame', reply_markup?: array}|array{_: 'inputBotInlineMessageMediaInvoice', invoice: array, provider_data: array, title?: array, description?: array, photo?: array, payload?: array, provider?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaWebPage', invert_media?: array, force_large_media?: array, force_small_media?: array, optional?: array, message?: array, entities?: list<array>, url?: array, reply_markup?: array}, id?: string, type?: string, title?: string, description?: string, url?: string, thumb?: array{_: 'inputWebDocument', url?: array, size?: array, mime_type?: array, attributes?: list<array>}, content?: array{_: 'inputWebDocument', url?: array, size?: array, mime_type?: array, attributes?: list<array>}}|array{_: 'inputBotInlineResultPhoto', send_message: array{_: 'inputBotInlineMessageMediaAuto', invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageText', no_webpage?: array, invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaGeo', geo_point?: array, heading?: array, period?: array, proximity_notification_radius?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaVenue', geo_point?: array, title?: array, address?: array, provider?: array, venue_id?: array, venue_type?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, vcard?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageGame', reply_markup?: array}|array{_: 'inputBotInlineMessageMediaInvoice', invoice: array, provider_data: array, title?: array, description?: array, photo?: array, payload?: array, provider?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaWebPage', invert_media?: array, force_large_media?: array, force_small_media?: array, optional?: array, message?: array, entities?: list<array>, url?: array, reply_markup?: array}, id?: string, type?: string, photo?: array}|array{_: 'inputBotInlineResultDocument', send_message: array{_: 'inputBotInlineMessageMediaAuto', invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageText', no_webpage?: array, invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaGeo', geo_point?: array, heading?: array, period?: array, proximity_notification_radius?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaVenue', geo_point?: array, title?: array, address?: array, provider?: array, venue_id?: array, venue_type?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, vcard?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageGame', reply_markup?: array}|array{_: 'inputBotInlineMessageMediaInvoice', invoice: array, provider_data: array, title?: array, description?: array, photo?: array, payload?: array, provider?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaWebPage', invert_media?: array, force_large_media?: array, force_small_media?: array, optional?: array, message?: array, entities?: list<array>, url?: array, reply_markup?: array}, id?: string, type?: string, title?: string, description?: string, document?: array}|array{_: 'inputBotInlineResultGame', send_message: array{_: 'inputBotInlineMessageMediaAuto', invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageText', no_webpage?: array, invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaGeo', geo_point?: array, heading?: array, period?: array, proximity_notification_radius?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaVenue', geo_point?: array, title?: array, address?: array, provider?: array, venue_id?: array, venue_type?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, vcard?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageGame', reply_markup?: array}|array{_: 'inputBotInlineMessageMediaInvoice', invoice: array, provider_data: array, title?: array, description?: array, photo?: array, payload?: array, provider?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaWebPage', invert_media?: array, force_large_media?: array, force_small_media?: array, optional?: array, message?: array, entities?: list<array>, url?: array, reply_markup?: array}, id?: string, short_name?: string}>|array<never, never> $results Array of Vector of results for the inline query @see https://docs.madelineproto.xyz/API_docs/types/InputBotInlineResult.html
     * @param int $cache_time The maximum amount of time in seconds that the result of the inline query may be cached on the server. Defaults to 300.
     * @param string $next_offset Pass the offset that a client should send in the next query with the same text to receive more results. Pass an empty string if there are no more results or if you don't support pagination. Offset length can't exceed 64 bytes.
     * @param array{_: 'inlineBotSwitchPM', text?: string, start_param?: string} $switch_pm If passed, clients will display a button on top of the remaining inline result list with the specified text, that switches the user to a private chat with the bot and sends the bot a start message with a certain parameter. @see https://docs.madelineproto.xyz/API_docs/types/InlineBotSwitchPM.html
     * @param array{_: 'inlineBotWebView', text?: string, url?: string} $switch_webview If passed, clients will display a button on top of the remaining inline result list with the specified text, that switches the user to the specified [inline mode mini app](https://core.telegram.org/api/bots/webapps#inline-mode-mini-apps). @see https://docs.madelineproto.xyz/API_docs/types/InlineBotWebView.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setInlineBotResults(bool|null $gallery = null, bool|null $private = null, int|null $query_id = 0, array $results = [], int|null $cache_time = 0, string|null $next_offset = null, array|null $switch_pm = null, array|null $switch_webview = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Send a result obtained using [messages.getInlineBotResults](https://docs.madelineproto.xyz/API_docs/methods/messages.getInlineBotResults.html).
     *
     * @param bool $silent Whether to send the message silently (no notification will be triggered on the other client)
     * @param bool $background Whether to send the message in background
     * @param bool $clear_draft Whether to clear the [draft](https://core.telegram.org/api/drafts)
     * @param bool $hide_via Whether to hide the `via @botname` in the resulting message (only for bot usernames encountered in the [config](https://docs.madelineproto.xyz/API_docs/constructors/config.html))
     * @param array|int|string $peer Destination @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $reply_to_msg_id ID Of message to reply to
     * @param int $top_msg_id This field must contain the topic ID only when replying to messages in forum topics different from the "General" topic (i.e. reply_to_msg_id is set and reply_to_msg_id != topicID and topicID != 1).
     * @param array{_: 'inputReplyToMessage', reply_to_msg_id?: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer?: array|int|string, story_id?: int} $reply_to If set, indicates that the message should be sent in reply to the specified message or story. @see https://docs.madelineproto.xyz/API_docs/types/InputReplyTo.html
     * @param int $query_id Query ID from [messages.getInlineBotResults](https://docs.madelineproto.xyz/API_docs/methods/messages.getInlineBotResults.html)
     * @param string $id Result ID from [messages.getInlineBotResults](https://docs.madelineproto.xyz/API_docs/methods/messages.getInlineBotResults.html)
     * @param int $schedule_date Scheduled message date for scheduled messages
     * @param array|int|string $send_as Send this message as the specified peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array{_: 'inputQuickReplyShortcut', shortcut?: string}|array{_: 'inputQuickReplyShortcutId', shortcut_id?: int} $quick_reply_shortcut @see https://docs.madelineproto.xyz/API_docs/types/InputQuickReplyShortcut.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendInlineBotResult(bool|null $silent = null, bool|null $background = null, bool|null $clear_draft = null, bool|null $hide_via = null, array|int|string|null $peer = null, int $reply_to_msg_id = 0, int $top_msg_id = 0, array|null $reply_to = null, int|null $query_id = 0, string|null $id = '', int|null $schedule_date = null, array|int|string|null $send_as = null, array|null $quick_reply_shortcut = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Find out if a media message's caption can be edited.
     *
     * @param array|int|string $peer Peer where the media was sent @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id ID of message
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messageEditData', caption: bool} @see https://docs.madelineproto.xyz/API_docs/types/messages.MessageEditData.html
     */
    public function getMessageEditData(array|int|string|null $peer = null, int|null $id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Edit message.
     *
     * @param bool $no_webpage Disable webpage preview
     * @param bool $invert_media If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
     * @param array|int|string $peer Where was the message sent @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id ID of the message to edit
     * @param string $message New message
     * @param \danog\MadelineProto\EventHandler\Media|string|array $media New attached media @see https://docs.madelineproto.xyz/API_docs/types/InputMedia.html
     * @param array $reply_markup Reply markup for inline keyboards @see https://docs.madelineproto.xyz/API_docs/types/ReplyMarkup.html
     * @param list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}> $entities Array of [Message entities for styled text](https://core.telegram.org/api/entities) @see https://docs.madelineproto.xyz/API_docs/types/MessageEntity.html
     * @param \danog\MadelineProto\ParseMode $parse_mode Whether to parse HTML or Markdown markup in the message
     * @param int $schedule_date Scheduled message date for [scheduled messages](https://core.telegram.org/api/scheduled-messages)
     * @param int $quick_reply_shortcut_id
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editMessage(bool|null $no_webpage = null, bool|null $invert_media = null, array|int|string|null $peer = null, int|null $id = 0, string|null $message = null, \danog\MadelineProto\EventHandler\Media|array|string|null $media = null, array|null $reply_markup = null, array|null $entities = null, \danog\MadelineProto\ParseMode $parse_mode = \danog\MadelineProto\ParseMode::TEXT, int|null $schedule_date = null, int|null $quick_reply_shortcut_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Edit an inline bot message.
     *
     * @param array{_: 'inputBotInlineMessageID', dc_id?: int, id?: int, access_hash?: int}|array{_: 'inputBotInlineMessageID64', dc_id?: int, owner_id?: int, id?: int, access_hash?: int} $id Sent inline message ID @see https://docs.madelineproto.xyz/API_docs/types/InputBotInlineMessageID.html
     * @param bool $no_webpage Disable webpage preview
     * @param bool $invert_media If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
     * @param string $message Message
     * @param \danog\MadelineProto\EventHandler\Media|string|array $media Media @see https://docs.madelineproto.xyz/API_docs/types/InputMedia.html
     * @param array $reply_markup Reply markup for inline keyboards @see https://docs.madelineproto.xyz/API_docs/types/ReplyMarkup.html
     * @param list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}> $entities Array of [Message entities for styled text](https://core.telegram.org/api/entities) @see https://docs.madelineproto.xyz/API_docs/types/MessageEntity.html
     * @param \danog\MadelineProto\ParseMode $parse_mode Whether to parse HTML or Markdown markup in the message
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function editInlineBotMessage(array $id, bool|null $no_webpage = null, bool|null $invert_media = null, string|null $message = null, \danog\MadelineProto\EventHandler\Media|array|string|null $media = null, array|null $reply_markup = null, array|null $entities = null, \danog\MadelineProto\ParseMode $parse_mode = \danog\MadelineProto\ParseMode::TEXT, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Press an inline callback button and get a callback answer from the bot.
     *
     * @param bool $game Whether this is a "play game" button
     * @param array|int|string $peer Where was the inline keyboard sent @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id ID of the Message with the inline keyboard
     * @param string $data Callback data
     * @param string|array $password For buttons [requiring you to verify your identity with your 2FA password](https://docs.madelineproto.xyz/API_docs/constructors/keyboardButtonCallback.html), the SRP payload generated using [SRP](https://core.telegram.org/api/srp). @see https://docs.madelineproto.xyz/API_docs/types/InputCheckPasswordSRP.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.botCallbackAnswer', alert: bool, has_url: bool, native_ui: bool, message?: string, url?: string, cache_time: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.BotCallbackAnswer.html
     */
    public function getBotCallbackAnswer(bool|null $game = null, array|int|string|null $peer = null, int|null $msg_id = 0, string|null $data = null, string|array|null $password = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Set the callback answer to a user button press (bots only).
     *
     * @param bool $alert Whether to show the message as a popup instead of a toast notification
     * @param int $query_id Query ID
     * @param string $message Popup to show
     * @param string $url URL to open
     * @param int $cache_time Cache validity
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setBotCallbackAnswer(bool|null $alert = null, int|null $query_id = 0, string|null $message = null, string|null $url = null, int|null $cache_time = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get dialog info of specified peers.
     *
     * @param list<array{_: 'inputDialogPeer', peer?: array|int|string}|array{_: 'inputDialogPeerFolder', folder_id?: int}>|array<never, never> $peers Array of Peers @see https://docs.madelineproto.xyz/API_docs/types/InputDialogPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.peerDialogs', state: array{_: 'updates.state', pts: int, qts: int, date: int, seq: int, unread_count: int}, dialogs: list<array{_: 'dialog', peer: array|int|string, notify_settings: array{_: 'peerNotifySettings', show_previews?: bool, silent?: bool, mute_until?: int, ios_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, android_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, other_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_muted?: bool, stories_hide_sender?: bool, stories_ios_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_android_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_other_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}}, pinned: bool, unread_mark: bool, view_forum_as_messages: bool, top_message: int, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, unread_mentions_count: int, unread_reactions_count: int, pts?: int, draft?: array{_: 'draftMessageEmpty', date?: int}|array{_: 'draftMessage', no_webpage: bool, invert_media: bool, reply_to?: array{_: 'inputReplyToMessage', reply_to_msg_id: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer: array|int|string, story_id: int}, message: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media?: \danog\MadelineProto\EventHandler\Media|string|array, date: int}, folder_id?: int, ttl_period?: int}|array{_: 'dialogFolder', folder: array{_: 'folder', autofill_new_broadcasts: bool, autofill_public_groups: bool, autofill_new_correspondents: bool, id: int, title: string, photo?: array{_: 'chatPhotoEmpty'}|array{_: 'chatPhoto', has_video: bool, photo_id: int, stripped_thumb?: string, dc_id: int}}, peer: array|int|string, pinned: bool, top_message: int, unread_muted_peers_count: int, unread_unmuted_peers_count: int, unread_muted_messages_count: int, unread_unmuted_messages_count: int}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id?: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionGiveawayLaunch'}|array{_: 'messageActionGiveawayResults', winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}, ttl_period?: int}>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.PeerDialogs.html
     */
    public function getPeerDialogs(array $peers = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Save a message [draft](https://core.telegram.org/api/drafts) associated to a chat.
     *
     * @param bool $no_webpage Disable generation of the webpage preview
     * @param bool $invert_media If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
     * @param int $reply_to_msg_id ID Of message to reply to
     * @param int $top_msg_id This field must contain the topic ID only when replying to messages in forum topics different from the "General" topic (i.e. reply_to_msg_id is set and reply_to_msg_id != topicID and topicID != 1).
     * @param array{_: 'inputReplyToMessage', reply_to_msg_id?: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer?: array|int|string, story_id?: int} $reply_to If set, indicates that the message should be sent in reply to the specified message or story. @see https://docs.madelineproto.xyz/API_docs/types/InputReplyTo.html
     * @param array|int|string $peer Destination of the message that should be sent @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $message The draft
     * @param list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}> $entities Array of Message [entities](https://core.telegram.org/api/entities) for styled text @see https://docs.madelineproto.xyz/API_docs/types/MessageEntity.html
     * @param \danog\MadelineProto\ParseMode $parse_mode Whether to parse HTML or Markdown markup in the message
     * @param \danog\MadelineProto\EventHandler\Media|string|array $media Attached media @see https://docs.madelineproto.xyz/API_docs/types/InputMedia.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function saveDraft(bool|null $no_webpage = null, bool|null $invert_media = null, int $reply_to_msg_id = 0, int $top_msg_id = 0, array|null $reply_to = null, array|int|string|null $peer = null, string|null $message = '', array|null $entities = null, \danog\MadelineProto\ParseMode $parse_mode = \danog\MadelineProto\ParseMode::TEXT, \danog\MadelineProto\EventHandler\Media|array|string|null $media = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Return all message [drafts](https://core.telegram.org/api/drafts).
     * Returns all the latest [updateDraftMessage](https://docs.madelineproto.xyz/API_docs/constructors/updateDraftMessage.html) updates related to all chats with drafts.
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function getAllDrafts(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get featured stickers.
     *
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.featuredStickersNotModified', count: int}|array{_: 'messages.featuredStickers', premium: bool, hash: list<int>, count: int, sets: list<array{_: 'stickerSetCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, cover: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}|array{_: 'stickerSetMultiCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, covers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetFullCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, keywords: list<array{_: 'stickerKeyword', document_id: int, keyword: list<string>}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetNoCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}}>, unread: list<int>} @see https://docs.madelineproto.xyz/API_docs/types/messages.FeaturedStickers.html
     */
    public function getFeaturedStickers(array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Mark new featured stickers as read.
     *
     * @param list<int>|array<never, never> $id IDs of stickersets to mark as read
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function readFeaturedStickers(array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get recent stickers.
     *
     * @param bool $attached Get stickers recently attached to photo or video files
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.recentStickersNotModified'}|array{_: 'messages.recentStickers', hash: list<int>, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, stickers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, dates: list<int>} @see https://docs.madelineproto.xyz/API_docs/types/messages.RecentStickers.html
     */
    public function getRecentStickers(bool|null $attached = null, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Add/remove sticker from recent stickers list.
     *
     * @param bool $unsave Whether to save or unsave the sticker
     * @param bool $attached Whether to add/remove stickers recently attached to photo or video files
     * @param array $id Sticker @see https://docs.madelineproto.xyz/API_docs/types/InputDocument.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function saveRecentSticker(bool $unsave, bool|null $attached = null, array|null $id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Clear recent stickers.
     *
     * @param bool $attached Set this flag to clear the list of stickers recently attached to photo or video files
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function clearRecentStickers(bool|null $attached = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get all archived stickers.
     *
     * @param bool $masks Get [mask stickers](https://core.telegram.org/api/stickers#mask-stickers)
     * @param bool $emojis Get [custom emoji stickers](https://core.telegram.org/api/custom-emoji)
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.archivedStickers', count: int, sets: list<array{_: 'stickerSetCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, cover: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}|array{_: 'stickerSetMultiCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, covers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetFullCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, keywords: list<array{_: 'stickerKeyword', document_id: int, keyword: list<string>}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetNoCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.ArchivedStickers.html
     */
    public function getArchivedStickers(bool|null $masks = null, bool|null $emojis = null, int|null $offset_id = 0, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get installed mask stickers.
     *
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.allStickersNotModified'}|array{_: 'messages.allStickers', hash: list<int>, sets: list<array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.AllStickers.html
     */
    public function getMaskStickers(array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get stickers attached to a photo or video.
     *
     * @param array{_: 'inputStickeredMediaPhoto', id?: array}|array{_: 'inputStickeredMediaDocument', id?: array} $media Stickered media @see https://docs.madelineproto.xyz/API_docs/types/InputStickeredMedia.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<array{_: 'stickerSetCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, cover: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}|array{_: 'stickerSetMultiCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, covers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetFullCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, keywords: list<array{_: 'stickerKeyword', document_id: int, keyword: list<string>}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetNoCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}}> Array of  @see https://docs.madelineproto.xyz/API_docs/types/StickerSetCovered.html
     */
    public function getAttachedStickers(array $media, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Use this method to set the score of the specified user in a game sent as a normal message (bots only).
     *
     * @param bool $edit_message Set this flag if the game message should be automatically edited to include the current scoreboard
     * @param bool $force Set this flag if the high score is allowed to decrease. This can be useful when fixing mistakes or banning cheaters
     * @param array|int|string $peer Unique identifier of target chat @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id Identifier of the sent message
     * @param array|int|string $user_id User identifier @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param int $score New score
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function setGameScore(bool|null $edit_message = null, bool|null $force = null, array|int|string|null $peer = null, int|null $id = 0, array|int|string|null $user_id = null, int|null $score = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Use this method to set the score of the specified user in a game sent as an inline message (bots only).
     *
     * @param array{_: 'inputBotInlineMessageID', dc_id?: int, id?: int, access_hash?: int}|array{_: 'inputBotInlineMessageID64', dc_id?: int, owner_id?: int, id?: int, access_hash?: int} $id ID of the inline message @see https://docs.madelineproto.xyz/API_docs/types/InputBotInlineMessageID.html
     * @param bool $edit_message Set this flag if the game message should be automatically edited to include the current scoreboard
     * @param bool $force Set this flag if the high score is allowed to decrease. This can be useful when fixing mistakes or banning cheaters
     * @param array|int|string $user_id User identifier @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param int $score New score
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setInlineGameScore(array $id, bool|null $edit_message = null, bool|null $force = null, array|int|string|null $user_id = null, int|null $score = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get highscores of a game.
     *
     * @param array|int|string $peer Where was the game sent @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id ID of message with game media attachment
     * @param array|int|string $user_id Get high scores made by a certain user @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.highScores', scores: list<array{_: 'highScore', pos: int, user_id: int, score: int}>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.HighScores.html
     */
    public function getGameHighScores(array|int|string|null $peer = null, int|null $id = 0, array|int|string|null $user_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get highscores of a game sent using an inline bot.
     *
     * @param array{_: 'inputBotInlineMessageID', dc_id?: int, id?: int, access_hash?: int}|array{_: 'inputBotInlineMessageID64', dc_id?: int, owner_id?: int, id?: int, access_hash?: int} $id ID of inline message @see https://docs.madelineproto.xyz/API_docs/types/InputBotInlineMessageID.html
     * @param array|int|string $user_id Get high scores of a certain user @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.highScores', scores: list<array{_: 'highScore', pos: int, user_id: int, score: int}>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.HighScores.html
     */
    public function getInlineGameHighScores(array $id, array|int|string|null $user_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get chats in common with a user.
     *
     * @param array|int|string $user_id User ID @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param int $max_id Maximum ID of chat to return (see [pagination](https://core.telegram.org/api/offsets))
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.chats', chats: list<array|int|string>}|array{_: 'messages.chatsSlice', count: int, chats: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Chats.html
     */
    public function getCommonChats(array|int|string|null $user_id = null, int|null $max_id = 0, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get [instant view](https://instantview.telegram.org) page.
     *
     * @param string $url URL of IV page to fetch
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.webPage', webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.WebPage.html
     */
    public function getWebPage(string|null $url = '', int|null $hash = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Pin/unpin a dialog.
     *
     * @param array{_: 'inputDialogPeer', peer?: array|int|string}|array{_: 'inputDialogPeerFolder', folder_id?: int} $peer The dialog to pin @see https://docs.madelineproto.xyz/API_docs/types/InputDialogPeer.html
     * @param bool $pinned Whether to pin or unpin the dialog
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function toggleDialogPin(array $peer, bool|null $pinned = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Reorder pinned dialogs.
     *
     * @param bool $force If set, dialogs pinned server-side but not present in the `order` field will be unpinned.
     * @param int $folder_id [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
     * @param list<array{_: 'inputDialogPeer', peer?: array|int|string}|array{_: 'inputDialogPeerFolder', folder_id?: int}>|array<never, never> $order Array of New dialog order @see https://docs.madelineproto.xyz/API_docs/types/InputDialogPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function reorderPinnedDialogs(bool|null $force = null, int|null $folder_id = 0, array $order = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get pinned dialogs.
     *
     * @param int $folder_id [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.peerDialogs', state: array{_: 'updates.state', pts: int, qts: int, date: int, seq: int, unread_count: int}, dialogs: list<array{_: 'dialog', peer: array|int|string, notify_settings: array{_: 'peerNotifySettings', show_previews?: bool, silent?: bool, mute_until?: int, ios_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, android_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, other_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_muted?: bool, stories_hide_sender?: bool, stories_ios_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_android_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_other_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}}, pinned: bool, unread_mark: bool, view_forum_as_messages: bool, top_message: int, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, unread_mentions_count: int, unread_reactions_count: int, pts?: int, draft?: array{_: 'draftMessageEmpty', date?: int}|array{_: 'draftMessage', no_webpage: bool, invert_media: bool, reply_to?: array{_: 'inputReplyToMessage', reply_to_msg_id: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer: array|int|string, story_id: int}, message: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media?: \danog\MadelineProto\EventHandler\Media|string|array, date: int}, folder_id?: int, ttl_period?: int}|array{_: 'dialogFolder', folder: array{_: 'folder', autofill_new_broadcasts: bool, autofill_public_groups: bool, autofill_new_correspondents: bool, id: int, title: string, photo?: array{_: 'chatPhotoEmpty'}|array{_: 'chatPhoto', has_video: bool, photo_id: int, stripped_thumb?: string, dc_id: int}}, peer: array|int|string, pinned: bool, top_message: int, unread_muted_peers_count: int, unread_unmuted_peers_count: int, unread_muted_messages_count: int, unread_unmuted_messages_count: int}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id?: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionGiveawayLaunch'}|array{_: 'messageActionGiveawayResults', winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}, ttl_period?: int}>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.PeerDialogs.html
     */
    public function getPinnedDialogs(int|null $folder_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * If you sent an invoice requesting a shipping address and the parameter is\_flexible was specified, the bot will receive an [updateBotShippingQuery](https://docs.madelineproto.xyz/API_docs/constructors/updateBotShippingQuery.html) update. Use this method to reply to shipping queries.
     *
     * @param int $query_id Unique identifier for the query to be answered
     * @param string $error Error message in human readable form that explains why it is impossible to complete the order (e.g. "Sorry, delivery to your desired address is unavailable"). Telegram will display this message to the user.
     * @param list<array{_: 'shippingOption', id?: string, title?: string, prices?: list<array{_: 'labeledPrice', label?: string, amount?: int}>}> $shipping_options Array of A vector of available shipping options. @see https://docs.madelineproto.xyz/API_docs/types/ShippingOption.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setBotShippingResults(int|null $query_id = 0, string|null $error = null, array|null $shipping_options = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Once the user has confirmed their payment and shipping details, the bot receives an [updateBotPrecheckoutQuery](https://docs.madelineproto.xyz/API_docs/constructors/updateBotPrecheckoutQuery.html) update.
     * Use this method to respond to such pre-checkout queries.
     * **Note**: Telegram must receive an answer within 10 seconds after the pre-checkout query was sent.
     *
     * @param bool $success Set this flag if everything is alright (goods are available, etc.) and the bot is ready to proceed with the order, otherwise do not set it, and set the `error` field, instead
     * @param int $query_id Unique identifier for the query to be answered
     * @param string $error Required if the `success` isn't set. Error message in human readable form that explains the reason for failure to proceed with the checkout (e.g. "Sorry, somebody just bought the last of our amazing black T-shirts while you were busy filling out your payment details. Please choose a different color or garment!"). Telegram will display this message to the user.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setBotPrecheckoutResults(bool|null $success = null, int|null $query_id = 0, string|null $error = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Upload a file and associate it to a chat (without actually sending it to the chat).
     *
     * @param string $business_connection_id
     * @param array|int|string $peer The chat, can be [inputPeerEmpty](https://docs.madelineproto.xyz/API_docs/constructors/inputPeerEmpty.html) for bots and [inputPeerSelf](https://docs.madelineproto.xyz/API_docs/constructors/inputPeerSelf.html) for users. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param \danog\MadelineProto\EventHandler\Media|string|array $media File uploaded in chunks as described in [files »](https://core.telegram.org/api/files) @see https://docs.madelineproto.xyz/API_docs/types/InputMedia.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}|array{_: 'messageExtendedMedia', media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}|array{_: 'storyItem', pinned: array, public: array, close_friends: array, min: array, noforwards: array, edited: array, contacts: array, selected_contacts: array, out: array, id: array, date: array, from_id?: array, fwd_from?: array, expire_date: array, caption?: array, entities?: list<array>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, media_areas?: list<array>, privacy?: list<array>, views?: array, sent_reaction?: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int} @see https://docs.madelineproto.xyz/API_docs/types/MessageMedia.html
     */
    public function uploadMedia(string|null $business_connection_id = null, array|int|string|null $peer = null, \danog\MadelineProto\EventHandler\Media|array|string|null $media = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Notify the other user in a private chat that a screenshot of the chat was taken.
     *
     * @param int $reply_to_msg_id ID Of message to reply to
     * @param int $top_msg_id This field must contain the topic ID only when replying to messages in forum topics different from the "General" topic (i.e. reply_to_msg_id is set and reply_to_msg_id != topicID and topicID != 1).
     * @param array{_: 'inputReplyToMessage', reply_to_msg_id?: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer?: array|int|string, story_id?: int} $reply_to Indicates the message that was screenshotted (the specified message ID can also be `0` to avoid indicating any specific message). @see https://docs.madelineproto.xyz/API_docs/types/InputReplyTo.html
     * @param array|int|string $peer Other user @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendScreenshotNotification(int $reply_to_msg_id = 0, int $top_msg_id = 0, array|null $reply_to = null, array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get faved stickers.
     *
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.favedStickersNotModified'}|array{_: 'messages.favedStickers', hash: list<int>, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, stickers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.FavedStickers.html
     */
    public function getFavedStickers(array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Mark or unmark a sticker as favorite.
     *
     * @param bool $unfave Whether to add or remove a sticker from favorites
     * @param array $id Sticker in question @see https://docs.madelineproto.xyz/API_docs/types/InputDocument.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function faveSticker(bool $unfave, array|null $id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get unread messages where we were mentioned.
     *
     * @param array|int|string $peer Peer where to look for mentions @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $top_msg_id If set, considers only messages within the specified [forum topic](https://core.telegram.org/api/forum#forum-topics)
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $add_offset [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param int $max_id Maximum message ID to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param int $min_id Minimum message ID to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getUnreadMentions(array|int|string|null $peer = null, int|null $top_msg_id = null, int|null $offset_id = 0, int|null $add_offset = 0, int|null $limit = 0, int|null $max_id = 0, int|null $min_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Mark mentions as read.
     *
     * @param array|int|string $peer Dialog @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $top_msg_id Mark as read only mentions within the specified [forum topic](https://core.telegram.org/api/forum#forum-topics)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedHistory', pts: int, pts_count: int, offset: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedHistory.html
     */
    public function readMentions(array|int|string|null $peer = null, int|null $top_msg_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get live location history of a certain user.
     *
     * @param array|int|string $peer User @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getRecentLocations(array|int|string|null $peer = null, int|null $limit = 0, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Send an [album or grouped media](https://core.telegram.org/api/files#albums-grouped-media).
     *
     * @param bool $silent Whether to send the album silently (no notification triggered)
     * @param bool $background Send in background?
     * @param bool $clear_draft Whether to clear [drafts](https://core.telegram.org/api/drafts)
     * @param bool $noforwards Only for bots, disallows forwarding and saving of the messages, even if the destination chat doesn't have [content protection](https://telegram.org/blog/protected-content-delete-by-date-and-more) enabled
     * @param bool $update_stickersets_order Whether to move used stickersets to top, [see here for more info on this flag »](https://core.telegram.org/api/stickers#recent-stickersets)
     * @param bool $invert_media If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
     * @param array|int|string $peer The destination chat @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $reply_to_msg_id ID Of message to reply to
     * @param int $top_msg_id This field must contain the topic ID only when replying to messages in forum topics different from the "General" topic (i.e. reply_to_msg_id is set and reply_to_msg_id != topicID and topicID != 1).
     * @param array{_: 'inputReplyToMessage', reply_to_msg_id?: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer?: array|int|string, story_id?: int} $reply_to If set, indicates that the message should be sent in reply to the specified message or story. @see https://docs.madelineproto.xyz/API_docs/types/InputReplyTo.html
     * @param list<array{_: 'inputSingleMedia', media?: \danog\MadelineProto\EventHandler\Media|string|array, message?: string, entities?: list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}>}>|array<never, never> $multi_media Array of The medias to send @see https://docs.madelineproto.xyz/API_docs/types/InputSingleMedia.html
     * @param int $schedule_date Scheduled message date for scheduled messages
     * @param array|int|string $send_as Send this message as the specified peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array{_: 'inputQuickReplyShortcut', shortcut?: string}|array{_: 'inputQuickReplyShortcutId', shortcut_id?: int} $quick_reply_shortcut @see https://docs.madelineproto.xyz/API_docs/types/InputQuickReplyShortcut.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendMultiMedia(bool|null $silent = null, bool|null $background = null, bool|null $clear_draft = null, bool|null $noforwards = null, bool|null $update_stickersets_order = null, bool|null $invert_media = null, array|int|string|null $peer = null, int $reply_to_msg_id = 0, int $top_msg_id = 0, array|null $reply_to = null, array $multi_media = [], int|null $schedule_date = null, array|int|string|null $send_as = null, array|null $quick_reply_shortcut = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Upload encrypted file and associate it to a secret chat.
     *
     * @param array $peer The secret chat to associate the file to @see https://docs.madelineproto.xyz/API_docs/types/InputEncryptedChat.html
     * @param mixed $file The file @see https://docs.madelineproto.xyz/API_docs/types/InputEncryptedFile.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'encryptedFileEmpty'}|array{_: 'encryptedFile', id: int, access_hash: int, size: int, dc_id: int, key_fingerprint: int} @see https://docs.madelineproto.xyz/API_docs/types/EncryptedFile.html
     */
    public function uploadEncryptedFile(array $peer, mixed $file = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Search for stickersets.
     *
     * @param bool $exclude_featured Exclude featured stickersets from results
     * @param string $q Query string
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.foundStickerSetsNotModified'}|array{_: 'messages.foundStickerSets', hash: list<int>, sets: list<array{_: 'stickerSetCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, cover: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}|array{_: 'stickerSetMultiCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, covers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetFullCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, keywords: list<array{_: 'stickerKeyword', document_id: int, keyword: list<string>}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetNoCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.FoundStickerSets.html
     */
    public function searchStickerSets(bool|null $exclude_featured = null, string|null $q = '', array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get message ranges for saving the user's chat history.
     *
     * @param int $takeoutId Takeout ID, generated using account.initTakeoutSession, see [the takeout docs](https://core.telegram.org/api/takeout) for more info.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<array{_: 'messageRange', min_id: int, max_id: int}> Array of  @see https://docs.madelineproto.xyz/API_docs/types/MessageRange.html
     */
    public function getSplitRanges(int $takeoutId, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Manually mark dialog as unread.
     *
     * @param array{_: 'inputDialogPeer', peer?: array|int|string}|array{_: 'inputDialogPeerFolder', folder_id?: int} $peer Dialog @see https://docs.madelineproto.xyz/API_docs/types/InputDialogPeer.html
     * @param bool $unread Mark as unread/read
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function markDialogUnread(array $peer, bool|null $unread = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get dialogs manually marked as unread.
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<array{_: 'dialogPeer', peer: array|int|string}|array{_: 'dialogPeerFolder', folder_id: int}> Array of  @see https://docs.madelineproto.xyz/API_docs/types/DialogPeer.html
     */
    public function getDialogUnreadMarks(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Clear all [drafts](https://core.telegram.org/api/drafts).
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function clearAllDrafts(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Pin a message.
     *
     * @param bool $silent Pin the message silently, without triggering a notification
     * @param bool $unpin Whether the message should unpinned or pinned
     * @param bool $pm_oneside Whether the message should only be pinned on the local side of a one-to-one chat
     * @param array|int|string $peer The peer where to pin the message @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id The message to pin or unpin
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function updatePinnedMessage(bool|null $silent = null, bool|null $unpin = null, bool|null $pm_oneside = null, array|int|string|null $peer = null, int|null $id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Vote in a [poll](https://docs.madelineproto.xyz/API_docs/constructors/poll.html).
     *
     * Starting from layer 159, the vote will be sent from the peer specified using [messages.saveDefaultSendAs](https://docs.madelineproto.xyz/API_docs/methods/messages.saveDefaultSendAs.html).
     *
     * @param array|int|string $peer The chat where the poll was sent @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id The message ID of the poll
     * @param list<string>|array<never, never> $options The options that were chosen
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendVote(array|int|string|null $peer = null, int|null $msg_id = 0, array $options = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get poll results.
     *
     * @param array|int|string $peer Peer where the poll was found @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id Message ID of poll message
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function getPollResults(array|int|string|null $peer = null, int|null $msg_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get count of online users in a chat.
     *
     * @param array|int|string $peer The chat @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'chatOnlines', onlines: int} @see https://docs.madelineproto.xyz/API_docs/types/ChatOnlines.html
     */
    public function getOnlines(array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Edit the description of a [group/supergroup/channel](https://core.telegram.org/api/channel).
     *
     * @param array|int|string $peer The [group/supergroup/channel](https://core.telegram.org/api/channel). @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $about The new description
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function editChatAbout(array|int|string|null $peer = null, string|null $about = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Edit the default banned rights of a [channel/supergroup/group](https://core.telegram.org/api/channel).
     *
     * @param array{_: 'chatBannedRights', view_messages?: bool, send_messages?: bool, send_media?: bool, send_stickers?: bool, send_gifs?: bool, send_games?: bool, send_inline?: bool, embed_links?: bool, send_polls?: bool, change_info?: bool, invite_users?: bool, pin_messages?: bool, manage_topics?: bool, send_photos?: bool, send_videos?: bool, send_roundvideos?: bool, send_audios?: bool, send_voices?: bool, send_docs?: bool, send_plain?: bool, until_date?: int} $banned_rights The new global rights @see https://docs.madelineproto.xyz/API_docs/types/ChatBannedRights.html
     * @param array|int|string $peer The peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editChatDefaultBannedRights(array $banned_rights, array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get localized [emoji keywords »](https://core.telegram.org/api/custom-emoji#emoji-keywords).
     *
     * @param string $lang_code Language code
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'emojiKeywordsDifference', lang_code: string, from_version: int, version: int, keywords: list<array{_: 'emojiKeyword', keyword: string, emoticons: list<string>}|array{_: 'emojiKeywordDeleted', keyword: string, emoticons: list<string>}>} @see https://docs.madelineproto.xyz/API_docs/types/EmojiKeywordsDifference.html
     */
    public function getEmojiKeywords(string|null $lang_code = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get changed [emoji keywords »](https://core.telegram.org/api/custom-emoji#emoji-keywords).
     *
     * @param string $lang_code Language code
     * @param int $from_version Previous stored emoji keyword list `version`
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'emojiKeywordsDifference', lang_code: string, from_version: int, version: int, keywords: list<array{_: 'emojiKeyword', keyword: string, emoticons: list<string>}|array{_: 'emojiKeywordDeleted', keyword: string, emoticons: list<string>}>} @see https://docs.madelineproto.xyz/API_docs/types/EmojiKeywordsDifference.html
     */
    public function getEmojiKeywordsDifference(string|null $lang_code = '', int|null $from_version = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Obtain a list of related languages that must be used when fetching [emoji keyword lists »](https://core.telegram.org/api/custom-emoji#emoji-keywords).
     *
     * Usually the method will return the passed language codes (if localized) + `en` + some language codes for similar languages (if applicable).
     *
     * @param list<string>|array<never, never> $lang_codes The user's language codes
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<array{_: 'emojiLanguage', lang_code: string}> Array of  @see https://docs.madelineproto.xyz/API_docs/types/EmojiLanguage.html
     */
    public function getEmojiKeywordsLanguages(array $lang_codes = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Returns an HTTP URL which can be used to automatically log in into translation platform and suggest new [emoji keywords »](https://core.telegram.org/api/custom-emoji#emoji-keywords). The URL will be valid for 30 seconds after generation.
     *
     * @param string $lang_code Language code for which the emoji keywords will be suggested
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'emojiURL', url: string} @see https://docs.madelineproto.xyz/API_docs/types/EmojiURL.html
     */
    public function getEmojiURL(string|null $lang_code = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get the number of results that would be found by a [messages.search](https://docs.madelineproto.xyz/API_docs/methods/messages.search.html) call with the same parameters.
     *
     * @param array|int|string $peer Peer where to search @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $saved_peer_id Search within the [saved message dialog »](https://core.telegram.org/api/saved-messages) with this ID. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $top_msg_id If set, consider only messages within the specified [forum topic](https://core.telegram.org/api/forum#forum-topics)
     * @param list<array{_: 'inputMessagesFilterEmpty'}|array{_: 'inputMessagesFilterPhotos'}|array{_: 'inputMessagesFilterVideo'}|array{_: 'inputMessagesFilterPhotoVideo'}|array{_: 'inputMessagesFilterDocument'}|array{_: 'inputMessagesFilterUrl'}|array{_: 'inputMessagesFilterGif'}|array{_: 'inputMessagesFilterVoice'}|array{_: 'inputMessagesFilterMusic'}|array{_: 'inputMessagesFilterChatPhotos'}|array{_: 'inputMessagesFilterPhoneCalls', missed?: bool}|array{_: 'inputMessagesFilterRoundVoice'}|array{_: 'inputMessagesFilterRoundVideo'}|array{_: 'inputMessagesFilterMyMentions'}|array{_: 'inputMessagesFilterGeo'}|array{_: 'inputMessagesFilterContacts'}|array{_: 'inputMessagesFilterPinned'}>|array<never, never> $filters Array of Search filters @see https://docs.madelineproto.xyz/API_docs/types/MessagesFilter.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<array{_: 'messages.searchCounter', filter: array{_: 'inputMessagesFilterEmpty'}|array{_: 'inputMessagesFilterPhotos'}|array{_: 'inputMessagesFilterVideo'}|array{_: 'inputMessagesFilterPhotoVideo'}|array{_: 'inputMessagesFilterDocument'}|array{_: 'inputMessagesFilterUrl'}|array{_: 'inputMessagesFilterGif'}|array{_: 'inputMessagesFilterVoice'}|array{_: 'inputMessagesFilterMusic'}|array{_: 'inputMessagesFilterChatPhotos'}|array{_: 'inputMessagesFilterPhoneCalls', missed: bool}|array{_: 'inputMessagesFilterRoundVoice'}|array{_: 'inputMessagesFilterRoundVideo'}|array{_: 'inputMessagesFilterMyMentions'}|array{_: 'inputMessagesFilterGeo'}|array{_: 'inputMessagesFilterContacts'}|array{_: 'inputMessagesFilterPinned'}, inexact: bool, count: int}> Array of  @see https://docs.madelineproto.xyz/API_docs/types/messages.SearchCounter.html
     */
    public function getSearchCounters(array|int|string|null $peer = null, array|int|string|null $saved_peer_id = null, int|null $top_msg_id = null, array $filters = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get more info about a Seamless Telegram Login authorization request, for more info [click here »](https://core.telegram.org/api/url-authorization).
     *
     * @param array|int|string $peer Peer where the message is located @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id The message
     * @param int $button_id The ID of the button with the authorization request
     * @param string $url URL used for [link URL authorization, click here for more info »](https://core.telegram.org/api/url-authorization#link-url-authorization)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'urlAuthResultRequest', request_write_access: bool, bot: array|int|string, domain: string}|array{_: 'urlAuthResultAccepted', url: string}|array{_: 'urlAuthResultDefault'} @see https://docs.madelineproto.xyz/API_docs/types/UrlAuthResult.html
     */
    public function requestUrlAuth(array|int|string|null $peer = null, int|null $msg_id = null, int|null $button_id = null, string|null $url = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Use this to accept a Seamless Telegram Login authorization request, for more info [click here »](https://core.telegram.org/api/url-authorization).
     *
     * @param bool $write_allowed Set this flag to allow the bot to send messages to you (if requested)
     * @param array|int|string $peer The location of the message @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id Message ID of the message with the login button
     * @param int $button_id ID of the login button
     * @param string $url URL used for [link URL authorization, click here for more info »](https://core.telegram.org/api/url-authorization#link-url-authorization)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'urlAuthResultRequest', request_write_access: bool, bot: array|int|string, domain: string}|array{_: 'urlAuthResultAccepted', url: string}|array{_: 'urlAuthResultDefault'} @see https://docs.madelineproto.xyz/API_docs/types/UrlAuthResult.html
     */
    public function acceptUrlAuth(bool|null $write_allowed = null, array|int|string|null $peer = null, int|null $msg_id = null, int|null $button_id = null, string|null $url = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Should be called after the user hides the [report spam/add as contact bar](https://core.telegram.org/api/action-bar) of a new chat, effectively prevents the user from executing the actions specified in the [action bar »](https://core.telegram.org/api/action-bar).
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function hidePeerSettingsBar(array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get scheduled messages.
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getScheduledHistory(array|int|string|null $peer = null, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get scheduled messages.
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id IDs of scheduled messages
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getScheduledMessages(array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Send scheduled messages right away.
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id Scheduled message IDs
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendScheduledMessages(array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Delete scheduled messages.
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id Scheduled message IDs
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function deleteScheduledMessages(array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get poll results for non-anonymous polls.
     *
     * @param array|int|string $peer Chat where the poll was sent @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id Message ID
     * @param string $option Get only results for the specified poll `option`
     * @param string $offset Offset for results, taken from the `next_offset` field of [messages.votesList](https://docs.madelineproto.xyz/API_docs/constructors/messages.votesList.html), initially an empty string. <br>Note: if no more results are available, the method call will return an empty `next_offset`; thus, avoid providing the `next_offset` returned in [messages.votesList](https://docs.madelineproto.xyz/API_docs/constructors/messages.votesList.html) if it is empty, to avoid an infinite loop.
     * @param int $limit Number of results to return
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.votesList', count: int, votes: list<array{_: 'messagePeerVote', peer: array|int|string, option: string, date: int}|array{_: 'messagePeerVoteInputOption', peer: array|int|string, date: int}|array{_: 'messagePeerVoteMultiple', peer: array|int|string, options: list<string>, date: int}>, chats: list<array|int|string>, users: list<array|int|string>, next_offset?: string} @see https://docs.madelineproto.xyz/API_docs/types/messages.VotesList.html
     */
    public function getPollVotes(array|int|string|null $peer = null, int|null $id = 0, string|null $option = null, string|null $offset = null, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Apply changes to multiple stickersets.
     *
     * @param bool $uninstall Uninstall the specified stickersets
     * @param bool $archive Archive the specified stickersets
     * @param bool $unarchive Unarchive the specified stickersets
     * @param list<array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id?: int, access_hash?: int}|array{_: 'inputStickerSetShortName', short_name?: string}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon?: string}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}|array{_: 'inputStickerSetEmojiChannelDefaultStatuses'}>|array<never, never> $stickersets Array of Stickersets to act upon @see https://docs.madelineproto.xyz/API_docs/types/InputStickerSet.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function toggleStickerSets(bool|null $uninstall = null, bool|null $archive = null, bool|null $unarchive = null, array $stickersets = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get [folders](https://core.telegram.org/api/folders).
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.dialogFilters', tags_enabled: bool, filters: list<array{_: 'dialogFilter', contacts: bool, non_contacts: bool, groups: bool, broadcasts: bool, bots: bool, exclude_muted: bool, exclude_read: bool, exclude_archived: bool, id: int, title: string, emoticon?: string, color?: int, pinned_peers: list<array|int|string>, include_peers: list<array|int|string>, exclude_peers: list<array|int|string>}|array{_: 'dialogFilterDefault'}|array{_: 'dialogFilterChatlist', has_my_invites: bool, id: int, title: string, emoticon?: string, color?: int, pinned_peers: list<array|int|string>, include_peers: list<array|int|string>}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.DialogFilters.html
     */
    public function getDialogFilters(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get [suggested folders](https://core.telegram.org/api/folders).
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<array{_: 'dialogFilterSuggested', filter: array{_: 'dialogFilter', contacts: bool, non_contacts: bool, groups: bool, broadcasts: bool, bots: bool, exclude_muted: bool, exclude_read: bool, exclude_archived: bool, id: int, title: string, emoticon?: string, color?: int, pinned_peers: list<array|int|string>, include_peers: list<array|int|string>, exclude_peers: list<array|int|string>}|array{_: 'dialogFilterDefault'}|array{_: 'dialogFilterChatlist', has_my_invites: bool, id: int, title: string, emoticon?: string, color?: int, pinned_peers: list<array|int|string>, include_peers: list<array|int|string>}, description: string}> Array of  @see https://docs.madelineproto.xyz/API_docs/types/DialogFilterSuggested.html
     */
    public function getSuggestedDialogFilters(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Update [folder](https://core.telegram.org/api/folders).
     *
     * @param int $id [Folder](https://core.telegram.org/api/folders) ID
     * @param array{_: 'dialogFilter', contacts?: bool, non_contacts?: bool, groups?: bool, broadcasts?: bool, bots?: bool, exclude_muted?: bool, exclude_read?: bool, exclude_archived?: bool, id?: int, title?: string, emoticon?: string, color?: int, pinned_peers?: list<array|int|string>, include_peers?: list<array|int|string>, exclude_peers?: list<array|int|string>}|array{_: 'dialogFilterDefault'}|array{_: 'dialogFilterChatlist', has_my_invites?: bool, id?: int, title?: string, emoticon?: string, color?: int, pinned_peers?: list<array|int|string>, include_peers?: list<array|int|string>} $filter [Folder](https://core.telegram.org/api/folders) info @see https://docs.madelineproto.xyz/API_docs/types/DialogFilter.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function updateDialogFilter(int|null $id = 0, array|null $filter = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Reorder [folders](https://core.telegram.org/api/folders).
     *
     * @param list<int>|array<never, never> $order New [folder](https://core.telegram.org/api/folders) order
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function updateDialogFiltersOrder(array $order = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Method for fetching previously featured stickers.
     *
     * @param int $offset Offset
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.featuredStickersNotModified', count: int}|array{_: 'messages.featuredStickers', premium: bool, hash: list<int>, count: int, sets: list<array{_: 'stickerSetCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, cover: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}|array{_: 'stickerSetMultiCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, covers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetFullCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, keywords: list<array{_: 'stickerKeyword', document_id: int, keyword: list<string>}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetNoCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}}>, unread: list<int>} @see https://docs.madelineproto.xyz/API_docs/types/messages.FeaturedStickers.html
     */
    public function getOldFeaturedStickers(int|null $offset = 0, int|null $limit = 0, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get messages in a reply thread.
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id Message ID
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $offset_date [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $add_offset [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param int $max_id If a positive value was transferred, the method will return only messages with ID smaller than max\_id
     * @param int $min_id If a positive value was transferred, the method will return only messages with ID bigger than min\_id
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getReplies(array|int|string|null $peer = null, int|null $msg_id = 0, int|null $offset_id = 0, int|null $offset_date = 0, int|null $add_offset = 0, int|null $limit = 0, int|null $max_id = 0, int|null $min_id = 0, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get [discussion message](https://core.telegram.org/api/threads) from the [associated discussion group](https://core.telegram.org/api/discussion) of a channel to show it on top of the comment section, without actually joining the group.
     *
     * @param array|int|string $peer [Channel ID](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id Message ID
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.discussionMessage', messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id?: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionGiveawayLaunch'}|array{_: 'messageActionGiveawayResults', winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}, ttl_period?: int}>, max_id?: int, read_inbox_max_id?: int, read_outbox_max_id?: int, unread_count: int, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.DiscussionMessage.html
     */
    public function getDiscussionMessage(array|int|string|null $peer = null, int|null $msg_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Mark a [thread](https://core.telegram.org/api/threads) as read.
     *
     * @param array|int|string $peer Group ID @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id ID of message that started the thread
     * @param int $read_max_id ID up to which thread messages were read
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function readDiscussion(array|int|string|null $peer = null, int|null $msg_id = 0, int|null $read_max_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * [Unpin](https://core.telegram.org/api/pin) all pinned messages.
     *
     * @param array|int|string $peer Chat where to unpin @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $top_msg_id [Forum topic](https://core.telegram.org/api/forum#forum-topics) where to unpin
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedHistory', pts: int, pts_count: int, offset: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedHistory.html
     */
    public function unpinAllMessages(array|int|string|null $peer = null, int|null $top_msg_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Delete a [chat](https://core.telegram.org/api/channel).
     *
     * @param array|int|string $chat_id Chat ID @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function deleteChat(array|int|string|null $chat_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Delete the entire phone call history.
     *
     * @param bool $revoke Whether to remove phone call history for participants as well
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedFoundMessages', pts: int, pts_count: int, offset: int, messages: list<int>} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedFoundMessages.html
     */
    public function deletePhoneCallHistory(bool|null $revoke = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Obtains information about a chat export file, generated by a foreign chat app, [click here for more info about imported chats »](https://core.telegram.org/api/import).
     *
     * @param string $import_head Beginning of the message file; up to 100 lines.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.historyImportParsed', pm: bool, group: bool, title?: string} @see https://docs.madelineproto.xyz/API_docs/types/messages.HistoryImportParsed.html
     */
    public function checkHistoryImport(string|null $import_head = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Import chat history from a foreign chat app into a specific Telegram chat, [click here for more info about imported chats »](https://core.telegram.org/api/import).
     *
     * @param mixed $file A file name or a file URL. You can also use amphp async streams, amphp HTTP response objects, and [much more](https://docs.madelineproto.xyz/docs/FILES.html#downloading-files)!
     * @param array|int|string $peer The Telegram chat where the [history should be imported](https://core.telegram.org/api/import). @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $media_count Number of media files associated with the chat that will be uploaded using [messages.uploadImportedMedia](https://docs.madelineproto.xyz/API_docs/methods/messages.uploadImportedMedia.html).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.historyImport', id: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.HistoryImport.html
     */
    public function initHistoryImport(mixed $file, array|int|string|null $peer = null, int|null $media_count = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Upload a media file associated with an [imported chat, click here for more info »](https://core.telegram.org/api/import).
     *
     * @param array|int|string $peer The Telegram chat where the media will be imported @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $import_id Identifier of a [history import session](https://core.telegram.org/api/import), returned by [messages.initHistoryImport](https://docs.madelineproto.xyz/API_docs/methods/messages.initHistoryImport.html)
     * @param string $file_name File name
     * @param \danog\MadelineProto\EventHandler\Media|string|array $media Media metadata @see https://docs.madelineproto.xyz/API_docs/types/InputMedia.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}|array{_: 'messageExtendedMedia', media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}|array{_: 'storyItem', pinned: array, public: array, close_friends: array, min: array, noforwards: array, edited: array, contacts: array, selected_contacts: array, out: array, id: array, date: array, from_id?: array, fwd_from?: array, expire_date: array, caption?: array, entities?: list<array>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, media_areas?: list<array>, privacy?: list<array>, views?: array, sent_reaction?: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int} @see https://docs.madelineproto.xyz/API_docs/types/MessageMedia.html
     */
    public function uploadImportedMedia(array|int|string|null $peer = null, int|null $import_id = 0, string|null $file_name = '', \danog\MadelineProto\EventHandler\Media|array|string|null $media = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Complete the [history import process](https://core.telegram.org/api/import), importing all messages into the chat.
     * To be called only after initializing the import with [messages.initHistoryImport](https://docs.madelineproto.xyz/API_docs/methods/messages.initHistoryImport.html) and uploading all files using [messages.uploadImportedMedia](https://docs.madelineproto.xyz/API_docs/methods/messages.uploadImportedMedia.html).
     *
     * @param array|int|string $peer The Telegram chat where the messages should be [imported, click here for more info »](https://core.telegram.org/api/import) @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $import_id Identifier of a history import session, returned by [messages.initHistoryImport](https://docs.madelineproto.xyz/API_docs/methods/messages.initHistoryImport.html).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function startHistoryImport(array|int|string|null $peer = null, int|null $import_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get info about the chat invites of a specific chat.
     *
     * @param bool $revoked Whether to fetch revoked chat invites
     * @param array|int|string $peer Chat @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $admin_id Whether to only fetch chat invites from this admin @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param int $offset_date [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param string $offset_link [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.exportedChatInvites', count: int, invites: list<array{_: 'chatInviteExported', revoked: bool, permanent: bool, request_needed: bool, link: string, admin_id: int, date: int, start_date?: int, expire_date?: int, usage_limit?: int, usage?: int, requested?: int, title?: string}|array{_: 'chatInvitePublicJoinRequests'}>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.ExportedChatInvites.html
     */
    public function getExportedChatInvites(bool|null $revoked = null, array|int|string|null $peer = null, array|int|string|null $admin_id = null, int|null $offset_date = null, string|null $offset_link = null, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get info about a chat invite.
     *
     * @param array|int|string $peer Chat @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $link Invite link
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.exportedChatInvite', invite: array{_: 'chatInviteExported', revoked: bool, permanent: bool, request_needed: bool, link: string, admin_id: int, date: int, start_date?: int, expire_date?: int, usage_limit?: int, usage?: int, requested?: int, title?: string}|array{_: 'chatInvitePublicJoinRequests'}, users: list<array|int|string>}|array{_: 'messages.exportedChatInviteReplaced', invite: array{_: 'chatInviteExported', revoked: bool, permanent: bool, request_needed: bool, link: string, admin_id: int, date: int, start_date?: int, expire_date?: int, usage_limit?: int, usage?: int, requested?: int, title?: string}|array{_: 'chatInvitePublicJoinRequests'}, new_invite: array{_: 'chatInviteExported', revoked: bool, permanent: bool, request_needed: bool, link: string, admin_id: int, date: int, start_date?: int, expire_date?: int, usage_limit?: int, usage?: int, requested?: int, title?: string}|array{_: 'chatInvitePublicJoinRequests'}, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.ExportedChatInvite.html
     */
    public function getExportedChatInvite(array|int|string|null $peer = null, string|null $link = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Edit an exported chat invite.
     *
     * @param bool $revoked Whether to revoke the chat invite
     * @param array|int|string $peer Chat @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $link Invite link
     * @param int $expire_date New expiration date
     * @param int $usage_limit Maximum number of users that can join using this link
     * @param bool $request_needed Whether admin confirmation is required before admitting each separate user into the chat
     * @param string $title Description of the invite link, visible only to administrators
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.exportedChatInvite', invite: array{_: 'chatInviteExported', revoked: bool, permanent: bool, request_needed: bool, link: string, admin_id: int, date: int, start_date?: int, expire_date?: int, usage_limit?: int, usage?: int, requested?: int, title?: string}|array{_: 'chatInvitePublicJoinRequests'}, users: list<array|int|string>}|array{_: 'messages.exportedChatInviteReplaced', invite: array{_: 'chatInviteExported', revoked: bool, permanent: bool, request_needed: bool, link: string, admin_id: int, date: int, start_date?: int, expire_date?: int, usage_limit?: int, usage?: int, requested?: int, title?: string}|array{_: 'chatInvitePublicJoinRequests'}, new_invite: array{_: 'chatInviteExported', revoked: bool, permanent: bool, request_needed: bool, link: string, admin_id: int, date: int, start_date?: int, expire_date?: int, usage_limit?: int, usage?: int, requested?: int, title?: string}|array{_: 'chatInvitePublicJoinRequests'}, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.ExportedChatInvite.html
     */
    public function editExportedChatInvite(bool|null $revoked = null, array|int|string|null $peer = null, string|null $link = '', int|null $expire_date = null, int|null $usage_limit = null, bool|null $request_needed = null, string|null $title = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Delete all revoked chat invites.
     *
     * @param array|int|string $peer Chat @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $admin_id ID of the admin that originally generated the revoked chat invites @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function deleteRevokedExportedChatInvites(array|int|string|null $peer = null, array|int|string|null $admin_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Delete a chat invite.
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $link Invite link
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function deleteExportedChatInvite(array|int|string|null $peer = null, string|null $link = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get info about chat invites generated by admins.
     *
     * @param array|int|string $peer Chat @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.chatAdminsWithInvites', admins: list<array{_: 'chatAdminWithInvites', admin_id: int, invites_count: int, revoked_invites_count: int}>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.ChatAdminsWithInvites.html
     */
    public function getAdminsWithInvites(array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get info about the users that joined the chat using a specific chat invite.
     *
     * @param bool $requested If set, only returns info about users with pending [join requests »](https://core.telegram.org/api/invites#join-requests)
     * @param array|int|string $peer Chat @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $link Invite link
     * @param string $q Search for a user in the pending [join requests »](https://core.telegram.org/api/invites#join-requests) list: only available when the `requested` flag is set, cannot be used together with a specific `link`.
     * @param int $offset_date [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param array|int|string $offset_user User ID for [pagination](https://core.telegram.org/api/offsets): if set, `offset_date` must also be set. @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.chatInviteImporters', count: int, importers: list<array{_: 'chatInviteImporter', requested: bool, via_chatlist: bool, user_id: int, date: int, about?: string, approved_by?: int}>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.ChatInviteImporters.html
     */
    public function getChatInviteImporters(bool|null $requested = null, array|int|string|null $peer = null, string|null $link = null, string|null $q = null, int|null $offset_date = 0, array|int|string|null $offset_user = null, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Set maximum Time-To-Live of all messages in the specified chat.
     *
     * @param array|int|string $peer The dialog @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $period Automatically delete all messages sent in the chat after this many seconds
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function setHistoryTTL(array|int|string|null $peer = null, int|null $period = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Check whether chat history exported from another chat app can be [imported into a specific Telegram chat, click here for more info »](https://core.telegram.org/api/import).
     *
     * If the check succeeds, and no RPC errors are returned, a [messages.CheckedHistoryImportPeer](https://docs.madelineproto.xyz/API_docs/types/messages.CheckedHistoryImportPeer.html) constructor will be returned, with a confirmation text to be shown to the user, before actually initializing the import.
     *
     * @param array|int|string $peer The chat where we want to [import history »](https://core.telegram.org/api/import). @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.checkedHistoryImportPeer', confirm_text: string} @see https://docs.madelineproto.xyz/API_docs/types/messages.CheckedHistoryImportPeer.html
     */
    public function checkHistoryImportPeer(array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Change the chat theme of a certain chat.
     *
     * @param array|int|string $peer Private chat where to change theme @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $emoticon Emoji, identifying a specific chat theme; a list of chat themes can be fetched using [account.getChatThemes](https://docs.madelineproto.xyz/API_docs/methods/account.getChatThemes.html)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function setChatTheme(array|int|string|null $peer = null, string|null $emoticon = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get which users read a specific message: only available for groups and supergroups with less than [`chat_read_mark_size_threshold` members](https://core.telegram.org/api/config#chat-read-mark-size-threshold), read receipts will be stored for [`chat_read_mark_expire_period` seconds after the message was sent](https://core.telegram.org/api/config#chat-read-mark-expire-period), see [client configuration for more info »](https://core.telegram.org/api/config#client-configuration).
     *
     * @param array|int|string $peer Dialog @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id Message ID
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<array{_: 'readParticipantDate', user_id: int, date: int}> Array of  @see https://docs.madelineproto.xyz/API_docs/types/ReadParticipantDate.html
     */
    public function getMessageReadParticipants(array|int|string|null $peer = null, int|null $msg_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Returns information about the next messages of the specified type in the chat split by days.
     *
     * Returns the results in reverse chronological order.
     * Can return partial results for the last returned day.
     *
     * @param array{_: 'inputMessagesFilterEmpty'}|array{_: 'inputMessagesFilterPhotos'}|array{_: 'inputMessagesFilterVideo'}|array{_: 'inputMessagesFilterPhotoVideo'}|array{_: 'inputMessagesFilterDocument'}|array{_: 'inputMessagesFilterUrl'}|array{_: 'inputMessagesFilterGif'}|array{_: 'inputMessagesFilterVoice'}|array{_: 'inputMessagesFilterMusic'}|array{_: 'inputMessagesFilterChatPhotos'}|array{_: 'inputMessagesFilterPhoneCalls', missed?: bool}|array{_: 'inputMessagesFilterRoundVoice'}|array{_: 'inputMessagesFilterRoundVideo'}|array{_: 'inputMessagesFilterMyMentions'}|array{_: 'inputMessagesFilterGeo'}|array{_: 'inputMessagesFilterContacts'}|array{_: 'inputMessagesFilterPinned'} $filter Message filter, [inputMessagesFilterEmpty](https://docs.madelineproto.xyz/API_docs/constructors/inputMessagesFilterEmpty.html), [inputMessagesFilterMyMentions](https://docs.madelineproto.xyz/API_docs/constructors/inputMessagesFilterMyMentions.html) filters are not supported by this method. @see https://docs.madelineproto.xyz/API_docs/types/MessagesFilter.html
     * @param array|int|string $peer Peer where to search @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $saved_peer_id Search within the [saved message dialog »](https://core.telegram.org/api/saved-messages) with this ID. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $offset_date [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.searchResultsCalendar', inexact: bool, count: int, min_date: int, min_msg_id: int, offset_id_offset?: int, periods: list<array{_: 'searchResultsCalendarPeriod', date: int, min_msg_id: int, max_msg_id: int, count: int}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id?: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionGiveawayLaunch'}|array{_: 'messageActionGiveawayResults', winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}, ttl_period?: int}>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.SearchResultsCalendar.html
     */
    public function getSearchResultsCalendar(array $filter, array|int|string|null $peer = null, array|int|string|null $saved_peer_id = null, int|null $offset_id = 0, int|null $offset_date = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Returns sparse positions of messages of the specified type in the chat to be used for shared media scroll implementation.
     *
     * Returns the results in reverse chronological order (i.e., in order of decreasing message\_id).
     *
     * @param array{_: 'inputMessagesFilterEmpty'}|array{_: 'inputMessagesFilterPhotos'}|array{_: 'inputMessagesFilterVideo'}|array{_: 'inputMessagesFilterPhotoVideo'}|array{_: 'inputMessagesFilterDocument'}|array{_: 'inputMessagesFilterUrl'}|array{_: 'inputMessagesFilterGif'}|array{_: 'inputMessagesFilterVoice'}|array{_: 'inputMessagesFilterMusic'}|array{_: 'inputMessagesFilterChatPhotos'}|array{_: 'inputMessagesFilterPhoneCalls', missed?: bool}|array{_: 'inputMessagesFilterRoundVoice'}|array{_: 'inputMessagesFilterRoundVideo'}|array{_: 'inputMessagesFilterMyMentions'}|array{_: 'inputMessagesFilterGeo'}|array{_: 'inputMessagesFilterContacts'}|array{_: 'inputMessagesFilterPinned'} $filter Message filter, [inputMessagesFilterEmpty](https://docs.madelineproto.xyz/API_docs/constructors/inputMessagesFilterEmpty.html), [inputMessagesFilterMyMentions](https://docs.madelineproto.xyz/API_docs/constructors/inputMessagesFilterMyMentions.html) filters are not supported by this method. @see https://docs.madelineproto.xyz/API_docs/types/MessagesFilter.html
     * @param array|int|string $peer Peer where to search @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $saved_peer_id Search within the [saved message dialog »](https://core.telegram.org/api/saved-messages) with this ID. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.searchResultsPositions', count: int, positions: list<array{_: 'searchResultPosition', msg_id: int, date: int, offset: int}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.SearchResultsPositions.html
     */
    public function getSearchResultsPositions(array $filter, array|int|string|null $peer = null, array|int|string|null $saved_peer_id = null, int|null $offset_id = 0, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Dismiss or approve a chat [join request](https://core.telegram.org/api/invites#join-requests) related to a specific chat or channel.
     *
     * @param bool $approved Whether to dismiss or approve the chat [join request »](https://core.telegram.org/api/invites#join-requests)
     * @param array|int|string $peer The chat or channel @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $user_id The user whose [join request »](https://core.telegram.org/api/invites#join-requests) should be dismissed or approved @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function hideChatJoinRequest(bool|null $approved = null, array|int|string|null $peer = null, array|int|string|null $user_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Dismiss or approve all [join requests](https://core.telegram.org/api/invites#join-requests) related to a specific chat or channel.
     *
     * @param bool $approved Whether to dismiss or approve all chat [join requests »](https://core.telegram.org/api/invites#join-requests)
     * @param array|int|string $peer The chat or channel @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $link Only dismiss or approve [join requests »](https://core.telegram.org/api/invites#join-requests) initiated using this invite link
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function hideAllChatJoinRequests(bool|null $approved = null, array|int|string|null $peer = null, string|null $link = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Enable or disable [content protection](https://telegram.org/blog/protected-content-delete-by-date-and-more) on a channel or chat.
     *
     * @param bool $enabled Enable or disable content protection
     * @param array|int|string $peer The chat or channel @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleNoForwards(bool $enabled, array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Change the default peer that should be used when sending messages, reactions, poll votes to a specific group.
     *
     * @param array|int|string $peer Group @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $send_as The default peer that should be used when sending messages to the group @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function saveDefaultSendAs(array|int|string|null $peer = null, array|int|string|null $send_as = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * React to message.
     *
     * Starting from layer 159, the reaction will be sent from the peer specified using [messages.saveDefaultSendAs](https://docs.madelineproto.xyz/API_docs/methods/messages.saveDefaultSendAs.html).
     *
     * @param bool $big Whether a bigger and longer reaction should be shown
     * @param bool $add_to_recent Whether to add this reaction to the [recent reactions list »](https://core.telegram.org/api/reactions#recent-reactions).
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id Message ID to react to
     * @param list<array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon?: string}|array{_: 'reactionCustomEmoji', document_id?: int}> $reaction Array of A list of reactions @see https://docs.madelineproto.xyz/API_docs/types/Reaction.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendReaction(bool|null $big = null, bool|null $add_to_recent = null, array|int|string|null $peer = null, int|null $msg_id = 0, array|null $reaction = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get [message reactions »](https://core.telegram.org/api/reactions).
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id Message IDs
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function getMessagesReactions(array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get [message reaction](https://core.telegram.org/api/reactions) list, along with the sender of each reaction.
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id Message ID
     * @param array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon?: string}|array{_: 'reactionCustomEmoji', document_id?: int} $reaction Get only reactions of this type @see https://docs.madelineproto.xyz/API_docs/types/Reaction.html
     * @param string $offset Offset for pagination (taken from the `next_offset` field of the returned [messages.MessageReactionsList](https://docs.madelineproto.xyz/API_docs/types/messages.MessageReactionsList.html)); empty in the first request.
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messageReactionsList', count: int, reactions: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}}>, chats: list<array|int|string>, users: list<array|int|string>, next_offset?: string} @see https://docs.madelineproto.xyz/API_docs/types/messages.MessageReactionsList.html
     */
    public function getMessageReactionsList(array|int|string|null $peer = null, int|null $id = 0, array|null $reaction = null, string|null $offset = null, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Change the set of [message reactions »](https://core.telegram.org/api/reactions) that can be used in a certain group, supergroup or channel.
     *
     * @param array{_: 'chatReactionsNone'}|array{_: 'chatReactionsAll', allow_custom?: bool}|array{_: 'chatReactionsSome', reactions?: list<array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon?: string}|array{_: 'reactionCustomEmoji', document_id?: int}>} $available_reactions Allowed reaction emojis @see https://docs.madelineproto.xyz/API_docs/types/ChatReactions.html
     * @param array|int|string $peer Group where to apply changes @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $reactions_limit
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function setChatAvailableReactions(array $available_reactions, array|int|string|null $peer = null, int|null $reactions_limit = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Obtain available [message reactions »](https://core.telegram.org/api/reactions).
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.availableReactionsNotModified'}|array{_: 'messages.availableReactions', hash: int, reactions: list<array{_: 'availableReaction', inactive: bool, premium: bool, reaction: string, title: string, static_icon: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, appear_animation: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, select_animation: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, activate_animation: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, effect_animation: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, around_animation?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, center_icon?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.AvailableReactions.html
     */
    public function getAvailableReactions(int|null $hash = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Change default emoji reaction to use in the quick reaction menu: the value is synced across devices and can be fetched using [help.getConfig, `reactions_default` field](https://docs.madelineproto.xyz/API_docs/methods/help.getConfig.html).
     *
     * @param array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon?: string}|array{_: 'reactionCustomEmoji', document_id?: int} $reaction New emoji reaction @see https://docs.madelineproto.xyz/API_docs/types/Reaction.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setDefaultReaction(array|null $reaction = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Translate a given text.
     *
     * [Styled text entities](https://core.telegram.org/api/entities) will only be preserved for [Telegram Premium](https://core.telegram.org/api/premium) users.
     *
     * @param array|int|string $peer If the text is a chat message, the peer ID @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int> $id A list of message IDs to translate
     * @param list<array{_: 'textWithEntities', text?: string, entities?: list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}>}> $text Array of A list of styled messages to translate @see https://docs.madelineproto.xyz/API_docs/types/TextWithEntities.html
     * @param string $to_lang Two-letter ISO 639-1 language code of the language to which the message is translated
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.translateResult', result: list<array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.TranslatedText.html
     */
    public function translateText(array|int|string|null $peer = null, array|null $id = null, array|null $text = null, string|null $to_lang = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get unread reactions to messages you sent.
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $top_msg_id If set, considers only reactions to messages within the specified [forum topic](https://core.telegram.org/api/forum#forum-topics)
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $add_offset [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param int $max_id Only return reactions for messages up until this message ID
     * @param int $min_id Only return reactions for messages starting from this message ID
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getUnreadReactions(array|int|string|null $peer = null, int|null $top_msg_id = null, int|null $offset_id = 0, int|null $add_offset = 0, int|null $limit = 0, int|null $max_id = 0, int|null $min_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Mark [message reactions »](https://core.telegram.org/api/reactions) as read.
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $top_msg_id Mark as read only reactions to messages within the specified [forum topic](https://core.telegram.org/api/forum#forum-topics)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedHistory', pts: int, pts_count: int, offset: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedHistory.html
     */
    public function readReactions(array|int|string|null $peer = null, int|null $top_msg_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * View and search recently sent media.
     * This method does not support pagination.
     *
     * @param array{_: 'inputMessagesFilterEmpty'}|array{_: 'inputMessagesFilterPhotos'}|array{_: 'inputMessagesFilterVideo'}|array{_: 'inputMessagesFilterPhotoVideo'}|array{_: 'inputMessagesFilterDocument'}|array{_: 'inputMessagesFilterUrl'}|array{_: 'inputMessagesFilterGif'}|array{_: 'inputMessagesFilterVoice'}|array{_: 'inputMessagesFilterMusic'}|array{_: 'inputMessagesFilterChatPhotos'}|array{_: 'inputMessagesFilterPhoneCalls', missed?: bool}|array{_: 'inputMessagesFilterRoundVoice'}|array{_: 'inputMessagesFilterRoundVideo'}|array{_: 'inputMessagesFilterMyMentions'}|array{_: 'inputMessagesFilterGeo'}|array{_: 'inputMessagesFilterContacts'}|array{_: 'inputMessagesFilterPinned'} $filter Message filter @see https://docs.madelineproto.xyz/API_docs/types/MessagesFilter.html
     * @param string $q Optional search query
     * @param int $limit Maximum number of results to return (max 100).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function searchSentMedia(array $filter, string|null $q = '', int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Returns installed attachment menu [bot mini apps »](https://core.telegram.org/api/bots/attach).
     *
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'attachMenuBotsNotModified'}|array{_: 'attachMenuBots', hash: list<int>, bots: list<array{_: 'attachMenuBot', inactive: bool, has_settings: bool, request_write_access: bool, show_in_attach_menu: bool, show_in_side_menu: bool, side_menu_disclaimer_needed: bool, bot_id: int, short_name: string, peer_types?: list<array{_: 'attachMenuPeerTypeSameBotPM'}|array{_: 'attachMenuPeerTypeBotPM'}|array{_: 'attachMenuPeerTypePM'}|array{_: 'attachMenuPeerTypeChat'}|array{_: 'attachMenuPeerTypeBroadcast'}>, icons: list<array{_: 'attachMenuBotIcon', name: string, icon: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, colors?: list<array{_: 'attachMenuBotIconColor', name: string, color: int}>}>}>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/AttachMenuBots.html
     */
    public function getAttachMenuBots(array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Returns attachment menu entry for a [bot mini app that can be launched from the attachment menu »](https://core.telegram.org/api/bots/attach).
     *
     * @param array|int|string $bot Bot ID @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'attachMenuBotsBot', bot: array{_: 'attachMenuBot', inactive: bool, has_settings: bool, request_write_access: bool, show_in_attach_menu: bool, show_in_side_menu: bool, side_menu_disclaimer_needed: bool, bot_id: int, short_name: string, peer_types?: list<array{_: 'attachMenuPeerTypeSameBotPM'}|array{_: 'attachMenuPeerTypeBotPM'}|array{_: 'attachMenuPeerTypePM'}|array{_: 'attachMenuPeerTypeChat'}|array{_: 'attachMenuPeerTypeBroadcast'}>, icons: list<array{_: 'attachMenuBotIcon', name: string, icon: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, colors?: list<array{_: 'attachMenuBotIconColor', name: string, color: int}>}>}, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/AttachMenuBotsBot.html
     */
    public function getAttachMenuBot(array|int|string|null $bot = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Enable or disable [web bot attachment menu »](https://core.telegram.org/api/bots/attach).
     *
     * @param bool $enabled Toggle
     * @param bool $write_allowed Whether the user authorizes the bot to write messages to them, if requested by [attachMenuBot](https://docs.madelineproto.xyz/API_docs/constructors/attachMenuBot.html).`request_write_access`
     * @param array|int|string $bot Bot ID @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function toggleBotInAttachMenu(bool $enabled, bool|null $write_allowed = null, array|int|string|null $bot = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Open a [bot mini app](https://core.telegram.org/bots/webapps), sending over user information after user confirmation.
     *
     * After calling this method, until the user closes the webview, [messages.prolongWebView](https://docs.madelineproto.xyz/API_docs/methods/messages.prolongWebView.html) must be called every 60 seconds.
     *
     * @param bool $from_bot_menu Whether the webview was opened by clicking on the bot's [menu button »](https://core.telegram.org/api/bots/menu).
     * @param bool $silent Whether the inline message that will be sent by the bot on behalf of the user once the web app interaction is [terminated](https://docs.madelineproto.xyz/API_docs/methods/messages.sendWebViewResultMessage.html) should be sent silently (no notifications for the receivers).
     * @param array|int|string $peer Dialog where the web app is being opened, and where the resulting message will be sent (see the [docs for more info »](https://core.telegram.org/api/bots/webapps)). @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $bot Bot that owns the [web app](https://core.telegram.org/api/bots/webapps) @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param string $url [Web app URL](https://core.telegram.org/api/bots/webapps)
     * @param string $start_param If the web app was opened from the attachment menu using a [attachment menu deep link](https://core.telegram.org/api/links#bot-attachment-or-side-menu-links), `start_param` should contain the `data` from the `startattach` parameter.
     * @param mixed $theme_params Any JSON-encodable data
     * @param string $platform Short name of the application; 0-64 English letters, digits, and underscores
     * @param int $reply_to_msg_id ID Of message to reply to
     * @param int $top_msg_id This field must contain the topic ID only when replying to messages in forum topics different from the "General" topic (i.e. reply_to_msg_id is set and reply_to_msg_id != topicID and topicID != 1).
     * @param array{_: 'inputReplyToMessage', reply_to_msg_id?: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer?: array|int|string, story_id?: int} $reply_to If set, indicates that the inline message that will be sent by the bot on behalf of the user once the web app interaction is [terminated](https://docs.madelineproto.xyz/API_docs/methods/messages.sendWebViewResultMessage.html) should be sent in reply to the specified message or story. @see https://docs.madelineproto.xyz/API_docs/types/InputReplyTo.html
     * @param array|int|string $send_as Open the web app as the specified peer, sending the resulting the message as the specified peer. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'webViewResultUrl', query_id: int, url: string} @see https://docs.madelineproto.xyz/API_docs/types/WebViewResult.html
     */
    public function requestWebView(bool|null $from_bot_menu = null, bool|null $silent = null, array|int|string|null $peer = null, array|int|string|null $bot = null, string|null $url = null, string|null $start_param = null, mixed $theme_params = null, string|null $platform = '', int $reply_to_msg_id = 0, int $top_msg_id = 0, array|null $reply_to = null, array|int|string|null $send_as = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Indicate to the server (from the user side) that the user is still using a web app.
     *
     * If the method returns a `QUERY_ID_INVALID` error, the webview must be closed.
     *
     * @param bool $silent Whether the inline message that will be sent by the bot on behalf of the user once the web app interaction is [terminated](https://docs.madelineproto.xyz/API_docs/methods/messages.sendWebViewResultMessage.html) should be sent silently (no notifications for the receivers).
     * @param array|int|string $peer Dialog where the web app was opened. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $bot Bot that owns the [web app](https://core.telegram.org/api/bots/webapps) @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param int $query_id Web app interaction ID obtained from [messages.requestWebView](https://docs.madelineproto.xyz/API_docs/methods/messages.requestWebView.html)
     * @param int $reply_to_msg_id ID Of message to reply to
     * @param int $top_msg_id This field must contain the topic ID only when replying to messages in forum topics different from the "General" topic (i.e. reply_to_msg_id is set and reply_to_msg_id != topicID and topicID != 1).
     * @param array{_: 'inputReplyToMessage', reply_to_msg_id?: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer?: array|int|string, story_id?: int} $reply_to If set, indicates that the inline message that will be sent by the bot on behalf of the user once the web app interaction is [terminated](https://docs.madelineproto.xyz/API_docs/methods/messages.sendWebViewResultMessage.html) should be sent in reply to the specified message or story. @see https://docs.madelineproto.xyz/API_docs/types/InputReplyTo.html
     * @param array|int|string $send_as Open the web app as the specified peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function prolongWebView(bool|null $silent = null, array|int|string|null $peer = null, array|int|string|null $bot = null, int|null $query_id = 0, int $reply_to_msg_id = 0, int $top_msg_id = 0, array|null $reply_to = null, array|int|string|null $send_as = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Open a [bot mini app](https://core.telegram.org/api/bots/webapps).
     *
     * @param bool $from_switch_webview Whether the webapp was opened by clicking on the `switch_webview` button shown on top of the inline results list returned by [messages.getInlineBotResults](https://docs.madelineproto.xyz/API_docs/methods/messages.getInlineBotResults.html).
     * @param bool $from_side_menu Set this flag if opening the Mini App from the installed [side menu entry »](https://core.telegram.org/api/bots/attach) or from a [Mini App link »](https://core.telegram.org/api/links#mini-app-links).
     * @param array|int|string $bot Bot that owns the mini app @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param string $url Web app URL, if opening from a keyboard button or inline result
     * @param string $start_param Start parameter, if opening from a [Mini App link »](https://core.telegram.org/api/links#mini-app-links).
     * @param mixed $theme_params Any JSON-encodable data
     * @param string $platform Short name of the application; 0-64 English letters, digits, and underscores
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'simpleWebViewResultUrl', url: string} @see https://docs.madelineproto.xyz/API_docs/types/SimpleWebViewResult.html
     */
    public function requestSimpleWebView(bool|null $from_switch_webview = null, bool|null $from_side_menu = null, array|int|string|null $bot = null, string|null $url = null, string|null $start_param = null, mixed $theme_params = null, string|null $platform = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Terminate webview interaction started with [messages.requestWebView](https://docs.madelineproto.xyz/API_docs/methods/messages.requestWebView.html), sending the specified message to the chat on behalf of the user.
     *
     * @param array{_: 'inputBotInlineResult', send_message: array{_: 'inputBotInlineMessageMediaAuto', invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageText', no_webpage?: array, invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaGeo', geo_point?: array, heading?: array, period?: array, proximity_notification_radius?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaVenue', geo_point?: array, title?: array, address?: array, provider?: array, venue_id?: array, venue_type?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, vcard?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageGame', reply_markup?: array}|array{_: 'inputBotInlineMessageMediaInvoice', invoice: array, provider_data: array, title?: array, description?: array, photo?: array, payload?: array, provider?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaWebPage', invert_media?: array, force_large_media?: array, force_small_media?: array, optional?: array, message?: array, entities?: list<array>, url?: array, reply_markup?: array}, id?: string, type?: string, title?: string, description?: string, url?: string, thumb?: array{_: 'inputWebDocument', url?: array, size?: array, mime_type?: array, attributes?: list<array>}, content?: array{_: 'inputWebDocument', url?: array, size?: array, mime_type?: array, attributes?: list<array>}}|array{_: 'inputBotInlineResultPhoto', send_message: array{_: 'inputBotInlineMessageMediaAuto', invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageText', no_webpage?: array, invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaGeo', geo_point?: array, heading?: array, period?: array, proximity_notification_radius?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaVenue', geo_point?: array, title?: array, address?: array, provider?: array, venue_id?: array, venue_type?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, vcard?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageGame', reply_markup?: array}|array{_: 'inputBotInlineMessageMediaInvoice', invoice: array, provider_data: array, title?: array, description?: array, photo?: array, payload?: array, provider?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaWebPage', invert_media?: array, force_large_media?: array, force_small_media?: array, optional?: array, message?: array, entities?: list<array>, url?: array, reply_markup?: array}, id?: string, type?: string, photo?: array}|array{_: 'inputBotInlineResultDocument', send_message: array{_: 'inputBotInlineMessageMediaAuto', invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageText', no_webpage?: array, invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaGeo', geo_point?: array, heading?: array, period?: array, proximity_notification_radius?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaVenue', geo_point?: array, title?: array, address?: array, provider?: array, venue_id?: array, venue_type?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, vcard?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageGame', reply_markup?: array}|array{_: 'inputBotInlineMessageMediaInvoice', invoice: array, provider_data: array, title?: array, description?: array, photo?: array, payload?: array, provider?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaWebPage', invert_media?: array, force_large_media?: array, force_small_media?: array, optional?: array, message?: array, entities?: list<array>, url?: array, reply_markup?: array}, id?: string, type?: string, title?: string, description?: string, document?: array}|array{_: 'inputBotInlineResultGame', send_message: array{_: 'inputBotInlineMessageMediaAuto', invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageText', no_webpage?: array, invert_media?: array, message?: array, entities?: list<array>, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaGeo', geo_point?: array, heading?: array, period?: array, proximity_notification_radius?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaVenue', geo_point?: array, title?: array, address?: array, provider?: array, venue_id?: array, venue_type?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaContact', phone_number?: array, first_name?: array, last_name?: array, vcard?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageGame', reply_markup?: array}|array{_: 'inputBotInlineMessageMediaInvoice', invoice: array, provider_data: array, title?: array, description?: array, photo?: array, payload?: array, provider?: array, reply_markup?: array}|array{_: 'inputBotInlineMessageMediaWebPage', invert_media?: array, force_large_media?: array, force_small_media?: array, optional?: array, message?: array, entities?: list<array>, url?: array, reply_markup?: array}, id?: string, short_name?: string} $result Message to send @see https://docs.madelineproto.xyz/API_docs/types/InputBotInlineResult.html
     * @param string $bot_query_id Webview interaction ID obtained from [messages.requestWebView](https://docs.madelineproto.xyz/API_docs/methods/messages.requestWebView.html)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'webViewMessageSent', msg_id?: array{_: 'inputBotInlineMessageID', dc_id: int, id: int, access_hash: int}|array{_: 'inputBotInlineMessageID64', dc_id: int, owner_id: int, id: int, access_hash: int}} @see https://docs.madelineproto.xyz/API_docs/types/WebViewMessageSent.html
     */
    public function sendWebViewResultMessage(array $result, string|null $bot_query_id = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Used by the user to relay data from an opened [reply keyboard bot mini app](https://core.telegram.org/api/bots/webapps) to the bot that owns it.
     *
     * @param array|int|string $bot Bot that owns the web app @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param string $button_text Text of the [keyboardButtonSimpleWebView](https://docs.madelineproto.xyz/API_docs/constructors/keyboardButtonSimpleWebView.html) that was pressed to open the web app.
     * @param string $data Data to relay to the bot, obtained from a [`web_app_data_send` JS event](https://core.telegram.org/api/web-events#web-app-data-send).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendWebViewData(array|int|string|null $bot = null, string|null $button_text = '', string|null $data = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * [Transcribe voice message](https://core.telegram.org/api/transcribe).
     *
     * @param array|int|string $peer Peer ID where the voice message was sent @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id Voice message ID
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.transcribedAudio', pending: bool, transcription_id: int, text: string, trial_remains_num?: int, trial_remains_until_date?: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.TranscribedAudio.html
     */
    public function transcribeAudio(array|int|string|null $peer = null, int|null $msg_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Rate [transcribed voice message](https://core.telegram.org/api/transcribe).
     *
     * @param bool $good Whether the transcription was correct
     * @param array|int|string $peer Peer where the voice message was sent @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id Message ID
     * @param int $transcription_id Transcription ID
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function rateTranscribedAudio(bool $good, array|int|string|null $peer = null, int|null $msg_id = 0, int|null $transcription_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Fetch [custom emoji stickers »](https://core.telegram.org/api/custom-emoji).
     *
     * Returns a list of [documents](https://docs.madelineproto.xyz/API_docs/constructors/document.html) with the animated custom emoji in TGS format, and a [documentAttributeCustomEmoji](https://docs.madelineproto.xyz/API_docs/constructors/documentAttributeCustomEmoji.html) attribute with the original emoji and info about the emoji stickerset this custom emoji belongs to.
     *
     * @param list<int>|array<never, never> $document_id [Custom emoji](https://core.telegram.org/api/custom-emoji) IDs from a [messageEntityCustomEmoji](https://docs.madelineproto.xyz/API_docs/constructors/messageEntityCustomEmoji.html).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}> Array of  @see https://docs.madelineproto.xyz/API_docs/types/Document.html
     */
    public function getCustomEmojiDocuments(array $document_id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Gets the list of currently installed [custom emoji stickersets](https://core.telegram.org/api/custom-emoji).
     *
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.allStickersNotModified'}|array{_: 'messages.allStickers', hash: list<int>, sets: list<array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.AllStickers.html
     */
    public function getEmojiStickers(array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Gets featured custom emoji stickersets.
     *
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.featuredStickersNotModified', count: int}|array{_: 'messages.featuredStickers', premium: bool, hash: list<int>, count: int, sets: list<array{_: 'stickerSetCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, cover: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}|array{_: 'stickerSetMultiCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, covers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetFullCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, keywords: list<array{_: 'stickerKeyword', document_id: int, keyword: list<string>}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetNoCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}}>, unread: list<int>} @see https://docs.madelineproto.xyz/API_docs/types/messages.FeaturedStickers.html
     */
    public function getFeaturedEmojiStickers(array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Report a [message reaction](https://core.telegram.org/api/reactions).
     *
     * @param array|int|string $peer Peer where the message was sent @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id Message ID
     * @param array|int|string $reaction_peer Peer that sent the reaction @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function reportReaction(array|int|string|null $peer = null, int|null $id = 0, array|int|string|null $reaction_peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Got popular [message reactions](https://core.telegram.org/api/reactions).
     *
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.reactionsNotModified'}|array{_: 'messages.reactions', hash: list<int>, reactions: list<array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Reactions.html
     */
    public function getTopReactions(int|null $limit = 0, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get recently used [message reactions](https://core.telegram.org/api/reactions).
     *
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.reactionsNotModified'}|array{_: 'messages.reactions', hash: list<int>, reactions: list<array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Reactions.html
     */
    public function getRecentReactions(int|null $limit = 0, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Clear recently used [message reactions](https://core.telegram.org/api/reactions).
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function clearRecentReactions(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get information about extended media.
     *
     * @param array|int|string $peer Peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id Message IDs
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function getExtendedMedia(array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Changes the default value of the Time-To-Live setting, applied to all new chats.
     *
     * @param int $period The new default Time-To-Live of all messages sent in new chats.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setDefaultHistoryTTL(int|null $period = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Gets the default value of the Time-To-Live setting, applied to all new chats.
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'defaultHistoryTTL', period: int} @see https://docs.madelineproto.xyz/API_docs/types/DefaultHistoryTTL.html
     */
    public function getDefaultHistoryTTL(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Send one or more chosen peers, as requested by a [keyboardButtonRequestPeer](https://docs.madelineproto.xyz/API_docs/constructors/keyboardButtonRequestPeer.html) button.
     *
     * @param array|int|string $peer The bot that sent the [keyboardButtonRequestPeer](https://docs.madelineproto.xyz/API_docs/constructors/keyboardButtonRequestPeer.html) button. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id ID of the message that contained the reply keyboard with the [keyboardButtonRequestPeer](https://docs.madelineproto.xyz/API_docs/constructors/keyboardButtonRequestPeer.html) button.
     * @param int $button_id The `button_id` field from the [keyboardButtonRequestPeer](https://docs.madelineproto.xyz/API_docs/constructors/keyboardButtonRequestPeer.html) constructor.
     * @param list<array|int|string>|array<never, never> $requested_peers Array of The chosen peers. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendBotRequestedPeer(array|int|string|null $peer = null, int|null $msg_id = 0, int|null $button_id = 0, array $requested_peers = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Represents a list of [emoji categories](https://core.telegram.org/api/custom-emoji#emoji-categories), to be used when selecting [custom emojis](https://core.telegram.org/api/custom-emoji).
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.emojiGroupsNotModified'}|array{_: 'messages.emojiGroups', hash: int, groups: list<array{_: 'emojiGroup', title: string, icon_emoji_id: int, emoticons: list<string>}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.EmojiGroups.html
     */
    public function getEmojiGroups(int|null $hash = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Represents a list of [emoji categories](https://core.telegram.org/api/custom-emoji#emoji-categories), to be used when selecting custom emojis to set as [custom emoji status](https://core.telegram.org/api).
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.emojiGroupsNotModified'}|array{_: 'messages.emojiGroups', hash: int, groups: list<array{_: 'emojiGroup', title: string, icon_emoji_id: int, emoticons: list<string>}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.EmojiGroups.html
     */
    public function getEmojiStatusGroups(int|null $hash = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Represents a list of [emoji categories](https://core.telegram.org/api/custom-emoji#emoji-categories), to be used when selecting custom emojis to set as [profile picture](https://core.telegram.org/api/files#sticker-profile-pictures).
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.emojiGroupsNotModified'}|array{_: 'messages.emojiGroups', hash: int, groups: list<array{_: 'emojiGroup', title: string, icon_emoji_id: int, emoticons: list<string>}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.EmojiGroups.html
     */
    public function getEmojiProfilePhotoGroups(int|null $hash = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Look for [custom emojis](https://core.telegram.org/api/custom-emoji) associated to a UTF8 emoji.
     *
     * @param string $emoticon The emoji
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'emojiListNotModified'}|array{_: 'emojiList', hash: list<int>, document_id: list<int>} @see https://docs.madelineproto.xyz/API_docs/types/EmojiList.html
     */
    public function searchCustomEmoji(string|null $emoticon = '', array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Show or hide the [real-time chat translation popup](https://core.telegram.org/api/translation) for a certain chat.
     *
     * @param bool $disabled Whether to disable or enable the real-time chat translation popup
     * @param array|int|string $peer The peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function togglePeerTranslations(bool|null $disabled = null, array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Obtain information about a [direct link Mini App](https://core.telegram.org/api/bots/webapps#direct-link-mini-apps).
     *
     * @param array{_: 'inputBotAppID', id?: int, access_hash?: int}|array{_: 'inputBotAppShortName', bot_id?: array|int|string, short_name?: string} $app Bot app information obtained from a [Direct Mini App deep link »](https://core.telegram.org/api/links#direct-mini-app-links). @see https://docs.madelineproto.xyz/API_docs/types/InputBotApp.html
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.botApp', app: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int>}, inactive: bool, request_write_access: bool, has_settings: bool} @see https://docs.madelineproto.xyz/API_docs/types/messages.BotApp.html
     */
    public function getBotApp(array $app, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Open a [bot mini app](https://core.telegram.org/bots/webapps) from a [direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links), sending over user information after user confirmation.
     *
     * After calling this method, until the user closes the webview, [messages.prolongWebView](https://docs.madelineproto.xyz/API_docs/methods/messages.prolongWebView.html) must be called every 60 seconds.
     *
     * @param array{_: 'inputBotAppID', id?: int, access_hash?: int}|array{_: 'inputBotAppShortName', bot_id?: array|int|string, short_name?: string} $app The app obtained by invoking [messages.getBotApp](https://docs.madelineproto.xyz/API_docs/methods/messages.getBotApp.html) as specified in the [direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links) docs. @see https://docs.madelineproto.xyz/API_docs/types/InputBotApp.html
     * @param bool $write_allowed Set this flag if the bot is asking permission to send messages to the user as specified in the [direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links) docs, and the user agreed.
     * @param array|int|string $peer If the client has clicked on the link in a Telegram chat, pass the chat's peer information; otherwise pass the bot's peer information, instead. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $start_param If the `startapp` query string parameter is present in the [direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links), pass it to `start_param`.
     * @param mixed $theme_params Any JSON-encodable data
     * @param string $platform Short name of the application; 0-64 English letters, digits, and underscores
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'appWebViewResultUrl', url: string} @see https://docs.madelineproto.xyz/API_docs/types/AppWebViewResult.html
     */
    public function requestAppWebView(array $app, bool|null $write_allowed = null, array|int|string|null $peer = null, string|null $start_param = null, mixed $theme_params = null, string|null $platform = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Set a custom [wallpaper »](https://core.telegram.org/api/wallpapers) in a specific private chat with another user.
     *
     * @param bool $for_both Only for [Premium](https://core.telegram.org/api/premium) users, sets the specified wallpaper for both users of the chat, without requiring confirmation from the other user.
     * @param bool $revert If we don't like the new wallpaper the other user of the chat has chosen for us using the `for_both` flag, we can re-set our previous wallpaper just on our side using this flag.
     * @param array|int|string $peer The private chat where the wallpaper will be set @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array{_: 'inputWallPaper', id?: int, access_hash?: int}|array{_: 'inputWallPaperSlug', slug?: string}|array{_: 'inputWallPaperNoFile', id?: int} $wallpaper The [wallpaper »](https://core.telegram.org/api/wallpapers), obtained as described in the [wallpaper documentation »](https://core.telegram.org/api/wallpapers#uploading-wallpapers); must **not** be provided when installing a wallpaper obtained from a [messageActionSetChatWallPaper](https://docs.madelineproto.xyz/API_docs/constructors/messageActionSetChatWallPaper.html) service message (`id` must be provided, instead). @see https://docs.madelineproto.xyz/API_docs/types/InputWallPaper.html
     * @param array{_: 'wallPaperSettings', blur?: bool, motion?: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string} $settings Wallpaper settings, obtained as described in the [wallpaper documentation »](https://core.telegram.org/api/wallpapers#uploading-wallpapers) or from [messageActionSetChatWallPaper](https://docs.madelineproto.xyz/API_docs/constructors/messageActionSetChatWallPaper.html).`wallpaper`.`settings`. @see https://docs.madelineproto.xyz/API_docs/types/WallPaperSettings.html
     * @param int $id If the wallpaper was obtained from a [messageActionSetChatWallPaper](https://docs.madelineproto.xyz/API_docs/constructors/messageActionSetChatWallPaper.html) service message, must contain the ID of that message.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function setChatWallPaper(bool|null $for_both = null, bool|null $revert = null, array|int|string|null $peer = null, array|null $wallpaper = null, array|null $settings = null, int|null $id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Search for [custom emoji stickersets »](https://core.telegram.org/api/custom-emoji).
     *
     * @param bool $exclude_featured Exclude featured stickersets from results
     * @param string $q Query string
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.foundStickerSetsNotModified'}|array{_: 'messages.foundStickerSets', hash: list<int>, sets: list<array{_: 'stickerSetCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, cover: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}|array{_: 'stickerSetMultiCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, covers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetFullCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, keywords: list<array{_: 'stickerKeyword', document_id: int, keyword: list<string>}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetNoCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.FoundStickerSets.html
     */
    public function searchEmojiStickerSets(bool|null $exclude_featured = null, string|null $q = '', array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Returns the current saved dialog list, see [here »](https://core.telegram.org/api/saved-messages) for more info.
     *
     * @param bool $exclude_pinned Exclude pinned dialogs
     * @param int $offset_date [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets) (`top_message` ID used for pagination)
     * @param array|int|string $offset_peer [Offset peer for pagination](https://core.telegram.org/api/offsets) @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $limit Number of list elements to be returned
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.savedDialogs', dialogs: list<array{_: 'savedDialog', peer: array|int|string, pinned: bool, top_message: int}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id?: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionGiveawayLaunch'}|array{_: 'messageActionGiveawayResults', winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}, ttl_period?: int}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'messages.savedDialogsSlice', count: int, dialogs: list<array{_: 'savedDialog', peer: array|int|string, pinned: bool, top_message: int}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id?: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionGiveawayLaunch'}|array{_: 'messageActionGiveawayResults', winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}, ttl_period?: int}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'messages.savedDialogsNotModified', count: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.SavedDialogs.html
     */
    public function getSavedDialogs(bool|null $exclude_pinned = null, int|null $offset_date = 0, int|null $offset_id = 0, array|int|string|null $offset_peer = null, int|null $limit = 0, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Returns [saved messages »](https://core.telegram.org/api/saved-messages) forwarded from a specific peer.
     *
     * @param array|int|string $peer Target peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $offset_id Only return messages starting from the specified message ID
     * @param int $offset_date Only return messages sent before the specified date
     * @param int $add_offset Number of list elements to be skipped, negative values are also accepted.
     * @param int $limit Number of results to return
     * @param int $max_id If a positive value was transferred, the method will return only messages with IDs less than **max\_id**
     * @param int $min_id If a positive value was transferred, the method will return only messages with IDs more than **min\_id**
     * @param list<int>|array<never, never> $hash [Result hash](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getSavedHistory(array|int|string|null $peer = null, int|null $offset_id = 0, int|null $offset_date = 0, int|null $add_offset = 0, int|null $limit = 0, int|null $max_id = 0, int|null $min_id = 0, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Deletes messages forwarded from a specific peer to [saved messages »](https://core.telegram.org/api/saved-messages).
     *
     * @param array|int|string $peer Peer, whose messages will be deleted from [saved messages »](https://core.telegram.org/api/saved-messages) @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $max_id Maximum ID of message to delete
     * @param int $min_date Delete all messages newer than this UNIX timestamp
     * @param int $max_date Delete all messages older than this UNIX timestamp
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedHistory', pts: int, pts_count: int, offset: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedHistory.html
     */
    public function deleteSavedHistory(array|int|string|null $peer = null, int|null $max_id = 0, int|null $min_date = null, int|null $max_date = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get pinned [saved dialogs, see here »](https://core.telegram.org/api/saved-messages) for more info.
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.savedDialogs', dialogs: list<array{_: 'savedDialog', peer: array|int|string, pinned: bool, top_message: int}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id?: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionGiveawayLaunch'}|array{_: 'messageActionGiveawayResults', winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}, ttl_period?: int}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'messages.savedDialogsSlice', count: int, dialogs: list<array{_: 'savedDialog', peer: array|int|string, pinned: bool, top_message: int}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id?: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionGiveawayLaunch'}|array{_: 'messageActionGiveawayResults', winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}, ttl_period?: int}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'messages.savedDialogsNotModified', count: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.SavedDialogs.html
     */
    public function getPinnedSavedDialogs(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Pin or unpin a [saved message dialog »](https://core.telegram.org/api/saved-messages).
     *
     * @param array{_: 'inputDialogPeer', peer?: array|int|string}|array{_: 'inputDialogPeerFolder', folder_id?: int} $peer The dialog to pin @see https://docs.madelineproto.xyz/API_docs/types/InputDialogPeer.html
     * @param bool $pinned Whether to pin or unpin the dialog
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function toggleSavedDialogPin(array $peer, bool|null $pinned = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Reorder pinned [saved message dialogs »](https://core.telegram.org/api/saved-messages).
     *
     * @param bool $force If set, dialogs pinned server-side but not present in the `order` field will be unpinned.
     * @param list<array{_: 'inputDialogPeer', peer?: array|int|string}|array{_: 'inputDialogPeerFolder', folder_id?: int}>|array<never, never> $order Array of New dialog order @see https://docs.madelineproto.xyz/API_docs/types/InputDialogPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function reorderPinnedSavedDialogs(bool|null $force = null, array $order = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     *
     *
     * @param array|int|string $peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $hash
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.savedReactionTagsNotModified'}|array{_: 'messages.savedReactionTags', tags: list<array{_: 'savedReactionTag', reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, title?: string, count: int}>, hash: list<int>} @see https://docs.madelineproto.xyz/API_docs/types/messages.SavedReactionTags.html
     */
    public function getSavedReactionTags(array|int|string|null $peer = null, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon?: string}|array{_: 'reactionCustomEmoji', document_id?: int} $reaction @see https://docs.madelineproto.xyz/API_docs/types/Reaction.html
     * @param string $title
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function updateSavedReactionTag(array|null $reaction = null, string|null $title = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     *
     *
     * @param list<int>|array<never, never> $hash
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.reactionsNotModified'}|array{_: 'messages.reactions', hash: list<int>, reactions: list<array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Reactions.html
     */
    public function getDefaultTagReactions(array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param array|int|string $peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'outboxReadDate', date: int} @see https://docs.madelineproto.xyz/API_docs/types/OutboxReadDate.html
     */
    public function getOutboxReadDate(array|int|string|null $peer = null, int|null $msg_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param list<int>|array<never, never> $hash
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.quickReplies', quick_replies: list<array{_: 'quickReply', shortcut_id: int, shortcut: string, top_message: int, count: int}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months: int, prize_description?: string, until_date: int}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id?: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int}|array{_: 'messageActionGiveawayLaunch'}|array{_: 'messageActionGiveawayResults', winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}, ttl_period?: int}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'messages.quickRepliesNotModified'} @see https://docs.madelineproto.xyz/API_docs/types/messages.QuickReplies.html
     */
    public function getQuickReplies(array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param list<int>|array<never, never> $order
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function reorderQuickReplies(array $order = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     *
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function checkQuickReplyShortcut(string|null $shortcut = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     *
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function editQuickReplyShortcut(int|null $shortcut_id = 0, string|null $shortcut = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     *
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function deleteQuickReplyShortcut(int|null $shortcut_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     *
     *
     * @param list<int> $id
     * @param list<int>|array<never, never> $hash
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getQuickReplyMessages(int|null $shortcut_id = 0, array|null $id = null, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param array|int|string $peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendQuickReplyMessages(array|int|string|null $peer = null, int|null $shortcut_id = 0, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param list<int>|array<never, never> $id
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function deleteQuickReplyMessages(int|null $shortcut_id = 0, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function toggleDialogFilterTags(bool $enabled, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     *
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.myStickers', count: int, sets: list<array{_: 'stickerSetCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, cover: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}|array{_: 'stickerSetMultiCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, covers: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetFullCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}, packs: list<array{_: 'stickerPack', emoticon: string, documents: list<int>}>, keywords: list<array{_: 'stickerKeyword', document_id: int, keyword: list<string>}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>}|array{_: 'stickerSetNoCovered', set: array{_: 'stickerSet', archived: bool, official: bool, masks: bool, emojis: bool, text_color: bool, channel_emoji_status: bool, creator: bool, installed_date?: int, id: int, access_hash: int, title: string, short_name: string, thumbs?: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: int, local_id: int, secret: int}|array{_: 'fileLocation', dc_id: int, volume_id: int, local_id: int, secret: int}, type: string, w: int, h: int, bytes: string}>, thumb_dc_id?: int, thumb_version?: int, thumb_document_id?: int, count: int, hash: int}}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.MyStickers.html
     */
    public function getMyStickers(int|null $offset_id = 0, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;
}
