<?php declare(strict_types=1);

/**
 * Copyright 2024 Daniil Gentili.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @author    Daniil Gentili <daniil@daniil.it>
 * @author    Alexander Pankratov <alexander@i-c-a.su>
 * @copyright 2016-2024 Daniil Gentili <daniil@daniil.it>
 * @copyright 2016-2024 Alexander Pankratov <alexander@i-c-a.su>
 * @license   https://opensource.org/license/apache-2-0 Apache 2.0
 * @link https://github.com/danog/AsyncOrm AsyncOrm documentation
 */

namespace danog\AsyncOrm\Internal\Serializer;

use danog\AsyncOrm\Serializer;

/**
 * Bool casting serializer.
 *
 * @internal
 *
 * @implements Serializer<bool>
 */
final class BoolString implements Serializer
{
    public function serialize(mixed $value): mixed
    {
        return match ($value) {
            true => '1',
            false => '0',
        };
    }
    public function deserialize(mixed $value): mixed
    {
        /** @psalm-suppress UnhandledMatchCondition Intentional */
        return match ($value) {
            '1' => true,
            '0' => false,
        };
    }
}
