---
description: "Async ORM based on AMPHP v3 and fibers."
title: "danog/async-orm"

---
# `danog/async-orm`

Async ORM based on AMPHP v3 and fibers.



## Abstract classes
* [\danog\AsyncOrm\DbArray: DB array interface.](danog/AsyncOrm/DbArray.md)
* [\danog\AsyncOrm\DbObject](danog/AsyncOrm/DbObject.md)
* [\danog\AsyncOrm\Serializer: Serializer interface.](danog/AsyncOrm/Serializer.md)
* [\danog\AsyncOrm\Settings: Base interface for ORM settings.](danog/AsyncOrm/Settings.md)
* [\danog\AsyncOrm\Driver\DriverArray: Base class for driver-based arrays.](danog/AsyncOrm/Driver/DriverArray.md)
* [\danog\AsyncOrm\Driver\SqlArray: Generic SQL database backend.](danog/AsyncOrm/Driver/SqlArray.md)
* [\danog\AsyncOrm\Settings\DriverSettings: Base settings class for database backends.](danog/AsyncOrm/Settings/DriverSettings.md)
* [\danog\AsyncOrm\Settings\SqlSettings: Generic SQL db backend settings.](danog/AsyncOrm/Settings/SqlSettings.md)

## Classes
* [\danog\AsyncOrm\DbArrayBuilder: Contains configuration needed to build a DbArray.](danog/AsyncOrm/DbArrayBuilder.md)
* [\danog\AsyncOrm\KeyType: Specifies the type of keys.](danog/AsyncOrm/KeyType.md)
* [\danog\AsyncOrm\ValueType: Specifies the serializer to use when saving values.](danog/AsyncOrm/ValueType.md)
* [\danog\AsyncOrm\Annotations\OrmMappedArray: Attribute use to autoconfigure ORM properties.](danog/AsyncOrm/Annotations/OrmMappedArray.md)
* [\danog\AsyncOrm\Driver\MemoryArray: Memory database backend.](danog/AsyncOrm/Driver/MemoryArray.md)
* [\danog\AsyncOrm\Serializer\Igbinary: Igbinary serializer.](danog/AsyncOrm/Serializer/Igbinary.md)
* [\danog\AsyncOrm\Serializer\Json: JSON serializer.](danog/AsyncOrm/Serializer/Json.md)
* [\danog\AsyncOrm\Serializer\Native: Native serializer.](danog/AsyncOrm/Serializer/Native.md)
* [\danog\AsyncOrm\Settings\MemorySettings: MemorySettings backend settings.](danog/AsyncOrm/Settings/MemorySettings.md)
* [\danog\AsyncOrm\Settings\MysqlSettings: MySQL backend settings.](danog/AsyncOrm/Settings/MysqlSettings.md)
* [\danog\AsyncOrm\Settings\PostgresSettings: Postgres backend settings.](danog/AsyncOrm/Settings/PostgresSettings.md)
* [\danog\AsyncOrm\Settings\RedisSettings: Redis backend settings.](danog/AsyncOrm/Settings/RedisSettings.md)

## Traits
* [\danog\AsyncOrm\DbAutoProperties: Trait that provides autoconfiguration of OrmMappedArray properties.](danog/AsyncOrm/DbAutoProperties.md)


---
Generated by [danog/phpdoc](https://phpdoc.daniil.it).  