---
title: "danog\\AsyncOrm\\Driver\\SqlArray: Generic SQL database backend."
description: ""

---
# `danog\AsyncOrm\Driver\SqlArray`
[Back to index](../../../index.md)

> Author: Daniil Gentili <daniil@daniil.it>  
> Author: Alexander Pankratov <alexander@i-c-a.su>  
  

Generic SQL database backend.  




## Method list:
* [`getIterator(): \Traversable<array-key, mixed>`](#getIterator)
* [`get(mixed $key): mixed`](#get)
* [`set(string|int $key, mixed $value): void`](#set)
* [`unset(string|int $key): void`](#unset)
* [`count(): int`](#count)
* [`clear(): void`](#clear)
* [`getInstance(\danog\AsyncOrm\DbArrayBuilder $config, \danog\AsyncOrm\DbArray<TTKey, TTValue> $previous): \danog\AsyncOrm\DbArray<TTKey, TTValue>`](#getInstance)
* [`isset(TKey $key): bool`](#isset)
* [`offsetGet(TKey $offset): TValue`](#offsetGet)
* [`offsetExists(TKey $offset): bool`](#offsetExists)
* [`offsetSet(TKey $offset, TValue $value): void`](#offsetSet)
* [`offsetUnset(TKey $offset): void`](#offsetUnset)
* [`getArrayCopy(): array`](#getArrayCopy)

## Methods:
### <a name="getIterator"></a> `getIterator(): \Traversable<array-key, mixed>`

Get iterator.


#### See also: 
* `\Traversable`




### <a name="get"></a> `get(mixed $key): mixed`




Parameters:

* `$key`: `mixed`   



### <a name="set"></a> `set(string|int $key, mixed $value): void`




Parameters:

* `$key`: `string|int`   
* `$value`: `mixed`   



### <a name="unset"></a> `unset(string|int $key): void`

Unset value for an offset.


Parameters:

* `$key`: `string|int`   



### <a name="count"></a> `count(): int`

Count elements.


Return value: The number of elements or public properties in the associated
            array or object, respectively.


### <a name="clear"></a> `clear(): void`

Clear all elements.



### <a name="getInstance"></a> `getInstance(\danog\AsyncOrm\DbArrayBuilder $config, \danog\AsyncOrm\DbArray<TTKey, TTValue> $previous): \danog\AsyncOrm\DbArray<TTKey, TTValue>`




Parameters:

* `$config`: `\danog\AsyncOrm\DbArrayBuilder`   
* `$previous`: `\danog\AsyncOrm\DbArray<TTKey, TTValue>`   


#### See also: 
* [`\danog\AsyncOrm\DbArrayBuilder`: Contains configuration needed to build a DbArray.](../../../danog/AsyncOrm/DbArrayBuilder.md)
* `TTKey`
* `TTValue`
* [`\danog\AsyncOrm\DbArray`: DB array interface.](../../../danog/AsyncOrm/DbArray.md)




### <a name="isset"></a> `isset(TKey $key): bool`

Check if element exists.


Parameters:

* `$key`: `TKey`   


#### See also: 
* `TKey`




### <a name="offsetGet"></a> `offsetGet(TKey $offset): TValue`




Parameters:

* `$offset`: `TKey`   


#### See also: 
* `TKey`
* `TValue`




### <a name="offsetExists"></a> `offsetExists(TKey $offset): bool`




Parameters:

* `$offset`: `TKey`   


#### See also: 
* `TKey`




### <a name="offsetSet"></a> `offsetSet(TKey $offset, TValue $value): void`




Parameters:

* `$offset`: `TKey`   
* `$value`: `TValue`   


#### See also: 
* `TKey`
* `TValue`




### <a name="offsetUnset"></a> `offsetUnset(TKey $offset): void`




Parameters:

* `$offset`: `TKey`   


#### See also: 
* `TKey`




### <a name="getArrayCopy"></a> `getArrayCopy(): array`





---
Generated by [danog/phpdoc](https://phpdoc.daniil.it)
