<?php

// ایجاد متغیر های عمومی
$C = new stdClass;
$T = new stdClass;

// توکن ربات
$C->token = '342591691:AAFsPrupQSzfXQTKhqqqT7LtXoT8rzEKt28';
$T->urlpathsrc = 'https://php8.rubixapp.ir/newbot/';
$T->filepath = $T->urlpathsrc.'temp/';


// تنظیم منطقه زمانی سرور برای نمایش صحیح ساعت ایران
date_default_timezone_set('Asia/Tehran');

if (file_get_contents('php://input') !== '' || file_get_contents('php://input') !== null) {
    $update = json_decode(file_get_contents('php://input'), true);
    if (is_array($update)) {
        if (isset($update['message'])) {
            $T->text = ((isset($update['message']['text'])) ? $update['message']['text'] : ((isset($update['message']['caption'])) ? $update['message']['caption'] : ''));
            $T->chat_id = $update['message']['chat']['id'];
            $T->message_id = $update['message']['message_id'];
            $T->from_id = $update['message']['from']['id'];
            $T->first_name = $update['message']['from']['first_name'];
            $T->chat_tp = $update['message']['chat']['type'];
            //$T->from_reply_id = $update['message']['from']['first_name'];
            //$T->reply_msg_id = $update['message']['reply_to_message']['message_id'];
            if (isset($update['message']['video'])) $T->video_id = $update['message']['video']['file_id'];
            if (isset($update['message']['audio'])) $T->audio_id = $update['message']['audio']['file_id'];
            if (isset($update['message']['photo'])) $T->photo_id = $update['message']['photo'][count($update['message']['photo']) - 1]['file_id'];
            //$T->gif_id = $update->message->document->file_id;
            $T->step = 'start';
            if (file_exists("data/$T->from_id/step.txt")) {
                $T->step = file_get_contents("data/$T->from_id/step.txt");
            }
        }
    }
}

function getUpdateType()
{
    $update = json_decode(file_get_contents('php://input'));
    if (isset($update->message->text)) return 'text';
    elseif (isset($update->message->photo)) return 'photo';
    elseif (isset($update->message->audio)) return 'audio';
    elseif (isset($update->message->voice)) return 'voice';
    elseif (isset($update->message->video)) return 'video';
}

function getUpdateInfo()
{
    $update = json_decode(file_get_contents('php://input'));
    if (isset($update->message->text)) return 'text';
    elseif (isset($update->message->photo)) return $update->message->photo[count($update->message->photo) - 1];
    elseif (isset($update->message->audio)) return $update->message->audio;
    elseif (isset($update->message->voice)) return $update->message->voice;
    elseif (isset($update->message->video)) return $update->message->video;
}

function getFile($file_id)
{
    $res = connect('getFile', array(
        'file_id' => $file_id
    ));
    return (isset($res->result->file_path) ? $res->result->file_path : '');
}


function saveFile($file_path)
{
    global $C;
    $full_path = 'https://api.telegram.org/file/bot' . $C->token . '/' . $file_path;
    file_put_contents('temp/' . $file_path, file_get_contents($full_path, false));
}

function saveFileForTag($file_path)
{
    global $C;

    $full_path = 'https://api.telegram.org/file/bot' . $C->token . '/' . $file_path;
    if (stripos('!' . $file_path, '.mp3')) file_put_contents('temp/music.mp3', file_get_contents($full_path, false));
    if (stripos('!' . $file_path, '.jpg')) file_put_contents('temp/photo.jpg', file_get_contents($full_path, false));
}


function realFilename($url)
{
    $headers = get_headers($url, 1);
    $headers = array_change_key_case($headers, CASE_LOWER);
    $realfilename = '';

    if (isset($headers['content-disposition'])) {
        $tmp_name = explode('=', $headers['content-disposition']);
        if ($tmp_name[1]) {
            $realfilename = trim($tmp_name[1], '";\'');
        }
    } else {
        $info = pathinfo($url);
        if (isset($info['extension'])) {
            $realfilename = $info['filename'] . '.' . $info['extension'];
        }
    }

    return $realfilename;
}


function get2th($source, $txt, $txt2)
{

    $from = strpos($source, $txt);

    if ($from === false)
        return null;

    $source = substr($source, $from + strlen($txt));
    $to = strpos($source, $txt2);

    if ($to === false)
        return null;

    $source = substr($source, 0, $to);
    return $source;
}

function get_url($link)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_VERBOSE, 0);
    curl_setopt($ch, CURLOPT_ENCODING, '');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:98.0) Gecko/20100101 Firefox/98.0");
    curl_setopt($ch, CURLOPT_URL, ($link));
    $response = curl_exec($ch);
    curl_close($ch);
    return ($response);
}

function get_url2($link)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_VERBOSE, 0);
    curl_setopt($ch, CURLOPT_ENCODING, '');
    curl_setopt($ch, CURLOPT_PROXY, '137.74.131.223');
    curl_setopt($ch, CURLOPT_PROXYPORT, '33128');
    curl_setopt($ch, CURLOPT_PROXYUSERPWD, "private:13579");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:98.0) Gecko/20100101 Firefox/98.0");
    curl_setopt($ch, CURLOPT_URL, ($link));
    $response = curl_exec($ch);
    curl_close($ch);
    return ($response);
}


function connect($method, $datas = array())
{
    global $C;
    $url = "https://api.telegram.org/bot" . $C->token . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);
    return json_decode($res);
}

function sendMessage($chat_id, $text)
{
    return connect('sendMessage', array(
        'chat_id' => $chat_id,
        'disable_web_page_preview' => true,
        'text' => $text,
        'parse_mode' => 'HTML'
    ))->result;
}

function editMessageText($chat_id, $msg_id, $text)
{
    return connect('editMessageText', array(
        'chat_id' => $chat_id,
        'disable_web_page_preview' => true,
        'text' => $text,
        'parse_mode' => 'HTML',
        'message_id' => $msg_id
    ));
}

function forwardMessage($chat_id, $from_chat_id, $message_id)
{
    return connect('forwardMessage', array(
        'chat_id' => $chat_id,
        'from_chat_id' => $from_chat_id,
        'message_id' => $message_id
    ))->result;
}

function deleteMessage($chat_id, $message_id)
{
    return connect('deleteMessage', array(
        'chat_id' => $chat_id,
        'message_id' => $message_id
    ))->result;
}

function getChat($chat_id)
{
    return connect('getChat', array(
        'chat_id' => $chat_id
    ))->result;
}

function getChatMember($chat_id, $user_id)
{
    return connect('getChatMember', array(
        'chat_id' => $chat_id,
        'user_id' => $user_id
    ))->result;
}

function getChatMembersCount($chat_id)
{
    return connect('getChatMembersCount', array(
        'chat_id' => $chat_id
    ))->result;
}


function keyboard($chat_id, $text, $buttons)
{
    return connect('sendMessage', array(
        'chat_id' => $chat_id,
        'text' => $text,
        'reply_markup' => json_encode(array(
            'keyboard' => $buttons,
            'resize_keyboard' => true,
            'one_time_keyboard' => true
        ))
    ))->result;
}

function inline($chat_id, $text, $buttons)
{
    return connect('sendMessage', array(
        'chat_id' => $chat_id,
        'text' => $text,
        'reply_markup' => json_encode(array(
            'inline_keyboard' => $buttons
        ))
    ))->result;
}

function sendPoll($chat_id, $question, $options)
{
    $post = array(
        'chat_id' => $chat_id,
        'question' => $question,
        'options' => $options,
        'is_anonymous' => false,
    );
    return connect('sendPoll', $post)->result;
}

function sendCA($chat_id, $action)
{
    switch ($action) {
        case 'text':
            $action1 = 'typing';
            break;
        case 'photo':
            $action1 = 'upload_photo';
            break;
        case 'video':
            $action1 = 'upload_video';
            break;
        case 'audio':
            $action1 = 'upload_audio';
            break;
    }
    $post = array(
        'chat_id' => $chat_id,
        'action' => $action1,
    );
    return connect('sendChatAction', $post)->result;
}

function sendPhoto($chat_id, $caption, $photo_id)
{
    $post = array(
        'chat_id' => $chat_id,
        'photo' => $photo_id,
        'caption' => $caption,
        'parse_mode' => 'HTML'
    );
    return connect('sendPhoto', $post)->result;
}


function sendAudio($chat_id, $caption, $audio_id)
{
    require_once('getid3/getid3.php');
    $filename = str_replace('%20', ' ', basename($audio_id, '.mp3'));
    file_put_contents($filename . '.mp3', file_get_contents($audio_id));
    list($singer, $song) = explode(' - ', $filename);
    $getID3 = new getID3;
    $tags = $getID3->analyze($filename . '.mp3');
    $image = $tags['comments']['picture']['0']['data'];
    file_put_contents($filename . '.jpg', $image);
    if (checkSize($filename . '.jpg') > 190) reducemp3cover($filename . '.jpg');
    $post = array(
        'chat_id' => $chat_id,
        'audio' => new CURLFile(realpath($filename . '.mp3')),
        'caption' => $caption,
        'duration' => round($tags['playtime_seconds']),
        'performer' => $singer,
        'title' => $song,
        'thumb' => new CURLFile(realpath($filename . '.jpg')),
        'parse_mode' => 'HTML'
    );
    $sendAudio = connect('sendAudio', $post);
    unlink($filename . '.mp3');
    unlink($filename . '.jpg');
    return $sendAudio->result;
}

function sendAudioByLink($chat_id, $audio_id)
{
    require_once('getid3/getid3.php');
    $filename = str_replace('%20', ' ', basename($audio_id, '.mp3'));
    file_put_contents($filename . '.mp3', file_get_contents($audio_id));
    list($singer, $song) = explode(' - ', $filename);
    $getID3 = new getID3;
    $tags = $getID3->analyze($filename . '.mp3');
    $image = $tags['comments']['picture']['0']['data'];
    file_put_contents($filename . '.jpg', $image);
    $link128 = str_replace(".mp3", "%20%5B128%5D.mp3", $audio_id);
    $dl320 = shorten($audio_id);
    $dl128 = shorten($link128);
    $singerfa = p2f($singer);
    $songfa = p2f($song);
    $caption = "\u{1F4A2} دانلود آهنگ جدید\n\u{1F5E3} $singerfa\n\u{1F3B5} $songfa\n#Top\n\u{1F4E5}MP3 - 320:\n$dl320\n\n\u{1F4E5}MP3 - 128:\n$dl128\n\n\u{1F194} @RubixMusic";
    sendPhoto($chat_id, $caption, new CURLFile(realpath($filename . '.jpg')));
    file_put_contents($filename . '.ogg', file_get_contents2($audio_id));
    sendVoice($chat_id, '', new CURLFile(realpath($filename . '.ogg')));
    if (checkSize($filename . '.jpg') > 190) reducemp3cover($filename . '.jpg');
    $post = array(
        'chat_id' => $chat_id,
        'audio' => new CURLFile(realpath($filename . '.mp3')),
        'caption' => "<a href=\"https://t.me/rubixmusicbot?start=search\">\u{1F3A7} ربات جستجوی موزیک</a>\n\u{1F194} @RubixMusic",
        'duration' => round($tags['playtime_seconds']),
        'performer' => $singer,
        'title' => $song,
        'thumb' => new CURLFile(realpath($filename . '.jpg')),
        'parse_mode' => 'HTML'
    );
    $sendAudio = connect('sendAudio', $post);
    unlink($filename . '.mp3');
    unlink($filename . '.ogg');
    unlink($filename . '.jpg');
    return $sendAudio->result;
}

function sendAudioid($chat_id, $caption, $audio_id)
{
    $post = array(
        'chat_id' => $chat_id,
        'audio' => $audio_id,
        'caption' => $caption,
    );
    return connect('sendAudio', $post)->result;
}


function sendVoice($chat_id, $caption, $voice_id)
{
    return connect('sendVoice', array(
        'chat_id' => $chat_id,
        'voice' => $voice_id,
        'caption' => $caption,
        //'duration'=>'60',
    ))->result;
}


function sendDocument($chat_id, $caption, $document_id)
{
    return connect('sendDocument', array(
        'chat_id' => $chat_id,
        'document' => $document_id,
        'caption' => $caption,
        'parse_mode' => 'HTML'
    ))->result;
}

function getMe()
{
    return connect('getMe')->result;
}


function checkSize($file)
{
    if (strpos('!' . $file, 'http')) $size = round(get_file_size($file) / 1024);
    else $size = round(filesize($file) / 1024);
    return $size;
}

function reducemp3cover($file)
{
    require_once("Kraken.php");
    $kraken = new Kraken("eb6394fe90ee4ff013b49cf4a26a8b25", "534a0bcff8ce23dc89fb9325997547eeab6481f2");
    $params = array(
        "file" => $file,
        "wait" => true,
        "lossy" => true,
        "quality" => 70,
        "resize" => array(
            "width" => 500,
            "height" => 500,
            "strategy" => "fit"
        )
    );
    $data = $kraken->upload($params);
    file_put_contents($file, file_get_contents($data["kraked_url"]));
}

function get_file_size($url)
{
    $file = $url;

    $ch = curl_init($file);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    $data = curl_exec($ch);
    curl_close($ch);

    if (preg_match('/Content-Length: (\d+)/', $data, $matches)) {

        // Contains file size in bytes
        $fileSize = (int)$matches[1];

        return $fileSize;
    }
}